/* Create tables if not exists */
source ./init_db.sql

/*Remove old netint users by userid */
delete from ni_user.`livetran_user` where userid=83464625;
delete from ni_user.`livetran_user` where userid=83464626;
delete from ni_user.`livetran_user` where userid=83464627;

delete from ni_user.`livetran_user_name` where userid=83464625;
delete from ni_user.`livetran_user_name` where userid=83464626;
delete from ni_user.`livetran_user_name` where userid=83464627;

delete from ni_user.`livetran_user_token` where userid=83464625;
delete from ni_user.`livetran_user_token` where userid=83464626;

/* First check for image and get/create image ID */
SET @image_id = (
    SELECT id
    FROM ni_nvs.`livetran_image`
    WHERE image_name = 'image59588888_20250108161544.png'
    AND status = 1
    LIMIT 1
);

/* Insert image record if it doesn't exist */
INSERT INTO ni_nvs.`livetran_image` (
    userid, user_name_id, image_id, image_name, image_name_md5,
    size, checksum, in_used, status, create_time, update_time
)
SELECT 73464625, 7000, 'b69100ebf7cd43a586c98e92e2589b88',
       'image59588888_20250108161544.png', '57fe9910a0a6b0618e4c3955d559cdea',
       16340, '2b6c39c88226d3ee3a59658be7de3d28', 1, 1, NOW(), NOW()
WHERE @image_id IS NULL;

/* Update image_id if we just inserted it */
SET @image_id = COALESCE(@image_id, LAST_INSERT_ID());

DELIMITER $$
-- basically does the below but for version 5.7
-- ALTER TABLE ni_nvs.`livetran_image` ADD COLUMN IF NOT EXISTS `image_id` VARCHAR(100) NOT NULL COMMENT 'IMAGE ID';
-- ALTER TABLE ni_nvs.`livetran_image` ADD COLUMN IF NOT EXISTS `image_name_md5` VARCHAR(100) NOT NULL COMMENT 'file name MD5';
-- etc...
CREATE PROCEDURE `AddColumnIfNotExists`()
BEGIN
    -- Check for `image_id` column and add if not exists
    IF NOT EXISTS (
        SELECT 1
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE TABLE_SCHEMA = 'ni_nvs'
        AND TABLE_NAME = 'livetran_image'
        AND COLUMN_NAME = 'image_id'
    ) THEN
        ALTER TABLE ni_nvs.`livetran_image` ADD COLUMN `image_id` VARCHAR(100) NOT NULL COMMENT 'IMAGE ID';
    END IF;

    -- Check for `image_name_md5` column and add if not exists
    IF NOT EXISTS (
        SELECT 1
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE TABLE_SCHEMA = 'ni_nvs'
        AND TABLE_NAME = 'livetran_image'
        AND COLUMN_NAME = 'image_name_md5'
    ) THEN
        ALTER TABLE ni_nvs.`livetran_image` ADD COLUMN `image_name_md5` VARCHAR(100) NOT NULL COMMENT 'file name MD5';
    END IF;

    -- Check for `in_used` column and add if not exists
    IF NOT EXISTS (
        SELECT 1
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE TABLE_SCHEMA = 'ni_nvs'
        AND TABLE_NAME = 'livetran_image'
        AND COLUMN_NAME = 'in_used'
    ) THEN
        ALTER TABLE ni_nvs.`livetran_image` ADD COLUMN `in_used` INT(2) NOT NULL COMMENT '0 unused, 1 in used';
    END IF;

    IF NOT EXISTS(
        SELECT 1
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE TABLE_SCHEMA = 'ni_nvs'
        AND TABLE_NAME = 'livetran_system_load'
        AND COLUMN_NAME = 'region'
    )THEN
        ALTER TABLE `ni_nvs`.`livetran_system_load` ADD COLUMN `region` varchar(20) NOT NULL AFTER `id`;
    END IF;

    IF NOT EXISTS(
        SELECT 1
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE TABLE_SCHEMA = 'ni_user'
        AND TABLE_NAME = 'livetran_user'
        AND COLUMN_NAME = 'expiry_date'
    )THEN
        ALTER TABLE `ni_user`.`livetran_user` ADD COLUMN `expiry_date` int(11) NULL NULL DEFAULT '0' COMMENT 'expiry time' AFTER `last_login_time` ;
    END IF;

    IF NOT EXISTS (
        SELECT 1
        FROM INFORMATION_SCHEMA.statistics
        WHERE TABLE_SCHEMA = 'ni_user'
        AND TABLE_NAME = 'livetran_user'
        AND INDEX_NAME = 'idx_em'
    ) THEN
        ALTER TABLE ni_user.`livetran_user` ADD INDEX `idx_em`(`email`, `status`) USING BTREE;
    END IF;

    IF NOT EXISTS (
        SELECT 1
        FROM information_schema.columns
        WHERE table_schema = 'ni_lms'
        AND table_name = 'livetran_stream_output_status_v3'
        AND column_name = 'latest_alert_type'
    ) THEN
        ALTER TABLE ni_lms.`livetran_stream_output_status_v3`
        ADD COLUMN `latest_alert_type` varchar(20) NULL DEFAULT NULL COMMENT 'info,error,warning';
    END IF;

    IF NOT EXISTS (
        SELECT 1
        FROM information_schema.columns
        WHERE table_schema = 'ni_lms'
        AND table_name = 'livetran_stream_output_status_v3'
        AND column_name = 'latest_alert_name'
    ) THEN
        ALTER TABLE ni_lms.`livetran_stream_output_status_v3`
        ADD COLUMN `latest_alert_name` varchar(255) NULL DEFAULT NULL;
    END IF;

    IF NOT EXISTS (
        SELECT 1
        FROM information_schema.columns
        WHERE table_schema = 'ni_lms'
        AND table_name = 'livetran_stream_output_status_v3'
        AND column_name = 'latest_alert_message'
    ) THEN
        ALTER TABLE ni_lms.`livetran_stream_output_status_v3`
        ADD COLUMN `latest_alert_message` text NULL DEFAULT NULL;
    END IF;

    IF NOT EXISTS (
        SELECT 1
        FROM information_schema.columns
        WHERE table_schema = 'ni_lms'
        AND table_name = 'livetran_stream_output_status_v3'
        AND column_name = 'latest_alert_time'
    ) THEN
        ALTER TABLE ni_lms.`livetran_stream_output_status_v3`
        ADD COLUMN `latest_alert_time` datetime NULL DEFAULT NULL;
    END IF;

    IF NOT EXISTS (
        SELECT 1
        FROM information_schema.statistics
        WHERE table_schema = 'ni_lms'
        AND table_name = 'livetran_stream_output_status_v3'
        AND index_name = 'idx_stream_id'
    ) THEN
        ALTER TABLE ni_lms.`livetran_stream_output_status_v3`
        ADD INDEX `idx_stream_id` (`stream_id`) USING BTREE;
    END IF;

     IF NOT EXISTS (
        SELECT 1
        FROM information_schema.columns
        WHERE table_schema = 'ni_lms'
        AND table_name = 'offline_tran'
        AND column_name = 'input_subs_files'
    ) THEN
        ALTER TABLE ni_lms.`offline_tran`
        ADD COLUMN `input_subs_files` text NULL DEFAULT NULL COMMENT 'JSON array of subtitle files';
    END IF;

    IF NOT EXISTS (
        SELECT 1
        FROM information_schema.columns
        WHERE table_schema = 'ni_lms'
        AND table_name = 'offline_tran'
        AND column_name = 'post_processing_status'
    ) THEN
        ALTER TABLE ni_lms.`offline_tran`
        ADD COLUMN `post_processing_status` tinyint(2) NOT NULL DEFAULT '-1' COMMENT '-1:none required,0:all done,1:task required';
    END IF;

    IF NOT EXISTS (
        SELECT 1
        FROM information_schema.columns
        WHERE table_schema = 'ni_lms'
        AND table_name = 'offline_tran'
        AND column_name = 'transcoding_start_time'
    ) THEN
        ALTER TABLE ni_lms.`offline_tran`
        ADD COLUMN `transcoding_start_time` datetime NULL DEFAULT NULL;
    END IF;

    IF NOT EXISTS (
        SELECT 1
        FROM information_schema.columns
        WHERE table_schema = 'ni_lms'
        AND table_name = 'offline_tran'
        AND column_name = 'transcoding_end_time'
    ) THEN
        ALTER TABLE ni_lms.`offline_tran`
        ADD COLUMN `transcoding_end_time` datetime NULL DEFAULT NULL;
    END IF;

    IF EXISTS (
        SELECT 1
        FROM information_schema.columns
        WHERE table_schema = 'ni_lms'
        AND table_name = 'offline_tran'
        AND column_name = 'status'
        AND CHARACTER_MAXIMUM_LENGTH < 50
    ) THEN
        ALTER TABLE ni_lms.`offline_tran`
        MODIFY COLUMN `status` varchar(50) COMMENT 'deleted,running,completed,failed,queued,unknown,transcoding completed: post-processing failed,transcoding completed: post-processing';
    END IF;
END$$

CREATE PROCEDURE `AddConstraintIfNotExists`()
BEGIN
    DECLARE constraint_exists INT DEFAULT 0;

    SELECT COUNT(*)
    INTO constraint_exists
    FROM information_schema.statistics
    WHERE table_schema = 'ni_lms'
    AND table_name = 'livetran_stream_origin'
    AND index_name = 'unique_output_stream_key';

    IF constraint_exists = 0 THEN
        ALTER TABLE ni_lms.`livetran_stream_origin` ADD CONSTRAINT `unique_output_stream_key` UNIQUE(`output_stream_key`, `region`);
    END IF;
END$$

CREATE PROCEDURE `UpsertTemplate`(
    IN p_userid INT,
    IN p_user_name_id INT,
    IN p_app VARCHAR(50),
    IN p_name VARCHAR(128),
    IN p_type VARCHAR(20),
    IN p_description VARCHAR(255),
    IN p_format VARCHAR(2048),
    IN p_output TEXT,
    IN p_senior_params VARCHAR(4096),
    IN p_ext_param TEXT
)
BEGIN
    DECLARE template_count INT;

    SELECT COUNT(*) INTO template_count
    FROM ni_nvs.livetran_template
    WHERE name = p_name AND userid = p_userid AND status = 1;

    IF template_count > 0 THEN
        UPDATE ni_nvs.livetran_template
        SET
            user_name_id = p_user_name_id,
            app = p_app,
            env_id = 0,
            type = p_type,
            description = p_description,
            mutil_bitrate_type = 1,
            format = p_format,
            output = p_output,
            senior_params = p_senior_params,
            ext_param = p_ext_param,
            is_default = 0,
            status = 1,
            update_time = NOW()
        WHERE name = p_name AND status = 1 AND userid = p_userid;
    ELSE
        INSERT INTO ni_nvs.livetran_template (
            userid, user_name_id, app, env_id, name, type,
            description, mutil_bitrate_type, format, output,
            senior_params, ext_param, is_default, status, create_time, update_time
        ) VALUES (
            p_userid, p_user_name_id, p_app, 0, p_name, p_type,
            p_description, 1, p_format, p_output,
            p_senior_params, p_ext_param, 0, 1, NOW(), NOW()
        );
    END IF;
END$$

CREATE PROCEDURE UpdatePlaybackRegion(IN region_name VARCHAR(255))
BEGIN
    DECLARE done INT DEFAULT FALSE;
    DECLARE row_id BIGINT;
    DECLARE i INT;
    DECLARE arr_length INT;

    DECLARE cur CURSOR FOR SELECT id FROM ni_lms.livetran_stream_v3;
    DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = TRUE;

    OPEN cur;

    read_loop: LOOP
        FETCH cur INTO row_id;
        IF done THEN
            LEAVE read_loop;
        END IF;

        SET arr_length = JSON_LENGTH(
            (SELECT playback_settings FROM ni_lms.livetran_stream_v3 WHERE id=row_id)
        );
        IF arr_length IS NULL THEN
            SET arr_length = 0;
        END IF;

        SET i = 0;
        WHILE i < arr_length DO
            UPDATE ni_lms.livetran_stream_v3
            SET playback_settings = JSON_SET(
                playback_settings,
                CONCAT('$[', i, '].output_urls[0].region'), region_name
            )
            WHERE id = row_id;
            SET i = i + 1;
        END WHILE;

    END LOOP;

    CLOSE cur;
END$$

DELIMITER ;

/* Alter table statements */
CALL `AddColumnIfNotExists`();
DROP PROCEDURE `AddColumnIfNotExists`;
CALL `AddConstraintIfNotExists`();
DROP PROCEDURE `AddConstraintIfNotExists`;

ALTER TABLE `ni_nvs`.`livetran_template` MODIFY COLUMN `name` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT 'template name' AFTER `env_id`;

ALTER TABLE ni_user.`livetran_user` MODIFY COLUMN `expiry_date` int(11) NULL NULL DEFAULT '0' COMMENT 'expiry time';

ALTER TABLE ni_notification.`livetran_domain` MODIFY COLUMN `domain` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL AFTER `user_name_id`;

/* First check and remember if Example_High_Quality-H.264 was default */
SET @was_h264_default = COALESCE((
    SELECT is_default
    FROM ni_nvs.`livetran_template`
    WHERE userid=73464625 AND name="Example_High_Quality-H.264"
    LIMIT 1
), 0);  /* Set to 0 if no record exists */

CALL `UpsertTemplate`(73464625, 7000, 'live', 'Example_High_Quality-H.264', 'live', 'H.264 5x Output Encoding Ladder 1080p-720p-540p-360p-270p',
'{\"limitInputCheckout\":0,\"gopSecond\":0,\"gopSize\":0,\"las\":1,\"scaleRulesLm\":\"short\",\"segmentDuration\":2,\"segmentsStored\":15,\"hlsFormat\":\"fmp4\",\"deinterlaceParity\":\"auto\",\"deinterlaceMode\":\"send_frame\"}',
CONCAT('{\"video\":[{\"codec\":\"h264\",\"bitrate\":4755,\"fps\":30,\"width\":1920,\"height\":1080},{\"codec\":\"h264\",\"bitrate\":2516,\"fps\":30,\"width\":1280,\"height\":720},{\"codec\":\"h264\",\"bitrate\":1640,\"fps\":30,\"width\":960,\"height\":540},{\"codec\":\"h264\",\"bitrate\":990,\"fps\":30,\"width\":640,\"height\":360},{\"codec\":\"h264\",\"bitrate\":697,\"fps\":30,\"width\":480,\"height\":270}],\"audio\":[],\"logo\":[{\"imgId\":\"', @image_id, '\",\"locationType\":\"pixel\",\"location\":\"\",\"x\":1710,\"y\":10}],\"defaultAudioLang\":\"und\",\"version\":1,\"setLogo\":true}'), '', '');

CALL `UpsertTemplate`(73464625, 7000, 'live', 'Example_High_Quality-H.265', 'live', 'H.265 5x Output Encoding Ladder 1080p-720p-540p-360p-270p',
'{\"limitInputCheckout\":0,\"gopSecond\":0,\"gopSize\":0,\"las\":1,\"scaleRulesLm\":\"short\",\"segmentDuration\":2,\"segmentsStored\":15,\"hlsFormat\":\"fmp4\",\"deinterlaceParity\":\"auto\",\"deinterlaceMode\":\"send_frame\"}',
CONCAT('{\"video\":[{\"codec\":\"h265\",\"bitrate\":3328,\"fps\":30,\"width\":1920,\"height\":1080},{\"codec\":\"h265\",\"bitrate\":1761,\"fps\":30,\"width\":1280,\"height\":720},{\"codec\":\"h265\",\"bitrate\":1148,\"fps\":30,\"width\":960,\"height\":540},{\"codec\":\"h265\",\"bitrate\":693,\"fps\":30,\"width\":640,\"height\":360},{\"codec\":\"h265\",\"bitrate\":500,\"fps\":30,\"width\":480,\"height\":270}],\"audio\":[],\"logo\":[{\"imgId\":\"', @image_id, '\",\"locationType\":\"pixel\",\"location\":\"\",\"x\":1710,\"y\":10}],\"defaultAudioLang\":\"und\",\"version\":1,\"setLogo\":true}'), '', '');

DROP PROCEDURE `UpsertTemplate`;

/* Set Example_High_Quality-H.265 as default if no default template exists */
UPDATE ni_nvs.`livetran_template`
SET is_default = '1'
WHERE userid = 73464625 AND (
    (name = 'Example_High_Quality-H.264' AND @was_h264_default = 1) OR
    (name = 'Example_High_Quality-H.265' AND @was_h264_default = 0 AND NOT EXISTS (
        SELECT 1
        FROM (SELECT * FROM ni_nvs.`livetran_template`) as t
        WHERE t.userid = 73464625 AND t.is_default = '1'
    ))
);

/* inject deinterlace options for old templates */
UPDATE ni_nvs.`livetran_template`
SET format = CASE
    -- If format is empty or NULL, initialize with both values
    WHEN format IS NULL OR format = '' THEN '{"deinterlaceParity":"auto","deinterlaceMode":"send_frame"}'
    -- If deinterlaceMode does not exist, add both values
    WHEN format NOT LIKE '%\"deinterlaceMode\":%' THEN CONCAT('{"deinterlaceParity":"auto","deinterlaceMode":"send_frame",', SUBSTRING(format, 2))
    ELSE format
  END;

/* Update hlsFormat from 'ts' to 'fmp4' for H.265 and AV1 codecs */
UPDATE ni_nvs.`livetran_template`
    SET format = JSON_SET(
        format,
        '$.hlsFormat',
        'fmp4'
    )
    WHERE format LIKE '%"hlsFormat":"ts"%'
        AND output LIKE '%"video":%'
        AND (
            output LIKE '%"codec":"h265"%'
            OR output LIKE '%"codec":"av1"%'
        );

/* Convert segmentWindows to segmentsStored */
UPDATE ni_nvs.`livetran_template`
SET format = JSON_SET(
    JSON_REMOVE(format, '$.segmentWindows'),
    '$.segmentsStored',
    GREATEST(
        2,
        FLOOR(CAST(JSON_EXTRACT(format, '$.segmentWindows') AS DECIMAL) / CAST(JSON_EXTRACT(format, '$.segmentDuration') AS DECIMAL))
    )
)
WHERE format LIKE '%"segmentWindows":%';

UPDATE ni_lms.livetran_stream_v3 SET regions='["Bitstreams"]' WHERE regions!='["Bitstreams"]';
UPDATE ni_lms.livetran_stream_v3 SET input_settings = JSON_SET(input_settings, '$.input_urls[0].region', 'Bitstreams');
UPDATE ni_lms.livetran_stream_output_status_v3 SET region='Bitstreams' WHERE region!='Bitstreams';
UPDATE ni_lms.livetran_stream_source_status_v3 SET region='Bitstreams' WHERE region!='Bitstreams';
DELETE from ni_lms.livetran_networking_settings where region != "Bitstreams";
UPDATE ni_nvs.livetran_task_v2 SET region='Bitstreams' WHERE region!='Bitstreams';

CALL UpdatePlaybackRegion('Bitstreams');
DROP PROCEDURE UpdatePlaybackRegion;

/* Update default user info for current product*/
source ./default_users.sql
