## Common Folders
* Contains common files for production and debug folders. 
* These folders are symlinked to the production and debug folders
* GUI, Nginx, SQL, Docker Compose, .env configs are placed here

## Prepare configs
* Follow "Prepare Environment Config Files" first as per below roles
* Use ../prepare_env/non_cluster.json file as per your host values.
* Make sure to save this config file at some other place to reuse next time.

## Copy and replace config files from another repository
```
cp ../lms/app/config/test/config_dual_cluster.toml  common/config/lms/config.toml
cp ../nvs/app/config/test/config_dual_cluster.toml  common/config/nvs/config.toml
cp ../stream-trans/app/config/test/config.toml  common/config/stream-trans/config.toml
```

## BQE needs one host as per below example
```
# If ./prepare_configs.py -p production is used for docker compose prep then no need to use --profile production
cd bqe on each host

# Production Run
Node-1  CLI503  (Role - All Services)
    docker compose --profile production up -d

# Debug Run
Node-1  CLI503  (Role - All Services)
    docker compose up -d
```
