/* Create tables if not exists */
source ./init_db.sql

/*Remove old netint users by userid */
delete from ni_user.`livetran_user` where userid=83464625;
delete from ni_user.`livetran_user` where userid=83464626;
delete from ni_user.`livetran_user` where userid=83464627;

delete from ni_user.`livetran_user_name` where userid=83464625;
delete from ni_user.`livetran_user_name` where userid=83464626;
delete from ni_user.`livetran_user_name` where userid=83464627;

delete from ni_user.`livetran_user_token` where userid=83464625;
delete from ni_user.`livetran_user_token` where userid=83464626;


DELIMITER $$
-- basically does the below but for version 5.7
-- ALTER TABLE ni_nvs.`livetran_image` ADD COLUMN IF NOT EXISTS `image_id` VARCHAR(100) NOT NULL COMMENT 'IMAGE ID';
-- ALTER TABLE ni_nvs.`livetran_image` ADD COLUMN IF NOT EXISTS `image_name_md5` VARCHAR(100) NOT NULL COMMENT 'file name MD5';
-- etc...
CREATE PROCEDURE `AddColumnIfNotExists`()
BEGIN
    IF NOT EXISTS(
        SELECT 1
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE TABLE_SCHEMA = 'ni_nvs'
        AND TABLE_NAME = 'livetran_system_load'
        AND COLUMN_NAME = 'region'
    )THEN
        ALTER TABLE `ni_nvs`.`livetran_system_load` ADD COLUMN `region` varchar(20) NOT NULL AFTER `id`;
    END IF;

    IF NOT EXISTS(
        SELECT 1
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE TABLE_SCHEMA = 'ni_user'
        AND TABLE_NAME = 'livetran_user'
        AND COLUMN_NAME = 'expiry_date'
    )THEN
        ALTER TABLE `ni_user`.`livetran_user` ADD COLUMN `expiry_date` int(11) NULL NULL DEFAULT '0' COMMENT 'expiry time' AFTER `last_login_time` ;
    END IF;

    IF NOT EXISTS (
        SELECT 1
        FROM INFORMATION_SCHEMA.statistics
        WHERE TABLE_SCHEMA = 'ni_user'
        AND TABLE_NAME = 'livetran_user'
        AND INDEX_NAME = 'idx_em'
    ) THEN
        ALTER TABLE ni_user.`livetran_user` ADD INDEX `idx_em`(`email`, `status`) USING BTREE;
    END IF;

    IF NOT EXISTS (
        SELECT 1
        FROM information_schema.columns
        WHERE table_schema = 'ni_lms'
        AND table_name = 'livetran_stream_output_status_v3'
        AND column_name = 'latest_alert_type'
    ) THEN
        ALTER TABLE ni_lms.`livetran_stream_output_status_v3`
        ADD COLUMN `latest_alert_type` varchar(20) NULL DEFAULT NULL COMMENT 'info,error,warning';
    END IF;

    IF NOT EXISTS (
        SELECT 1
        FROM information_schema.columns
        WHERE table_schema = 'ni_lms'
        AND table_name = 'livetran_stream_output_status_v3'
        AND column_name = 'latest_alert_name'
    ) THEN
        ALTER TABLE ni_lms.`livetran_stream_output_status_v3`
        ADD COLUMN `latest_alert_name` varchar(255) NULL DEFAULT NULL;
    END IF;

    IF NOT EXISTS (
        SELECT 1
        FROM information_schema.columns
        WHERE table_schema = 'ni_lms'
        AND table_name = 'livetran_stream_output_status_v3'
        AND column_name = 'latest_alert_message'
    ) THEN
        ALTER TABLE ni_lms.`livetran_stream_output_status_v3`
        ADD COLUMN `latest_alert_message` text NULL DEFAULT NULL;
    END IF;

    IF NOT EXISTS (
        SELECT 1
        FROM information_schema.columns
        WHERE table_schema = 'ni_lms'
        AND table_name = 'livetran_stream_output_status_v3'
        AND column_name = 'latest_alert_time'
    ) THEN
        ALTER TABLE ni_lms.`livetran_stream_output_status_v3`
        ADD COLUMN `latest_alert_time` datetime NULL DEFAULT NULL;
    END IF;

    IF NOT EXISTS (
        SELECT 1
        FROM information_schema.statistics
        WHERE table_schema = 'ni_lms'
        AND table_name = 'livetran_stream_output_status_v3'
        AND index_name = 'idx_stream_id'
    ) THEN
        ALTER TABLE ni_lms.`livetran_stream_output_status_v3`
        ADD INDEX `idx_stream_id` (`stream_id`) USING BTREE;
    END IF;

     IF NOT EXISTS (
        SELECT 1
        FROM information_schema.columns
        WHERE table_schema = 'ni_lms'
        AND table_name = 'offline_tran'
        AND column_name = 'input_subs_files'
    ) THEN
        ALTER TABLE ni_lms.`offline_tran`
        ADD COLUMN `input_subs_files` text NULL DEFAULT NULL COMMENT 'JSON array of subtitle files';
    END IF;

    IF NOT EXISTS (
        SELECT 1
        FROM information_schema.columns
        WHERE table_schema = 'ni_lms'
        AND table_name = 'offline_tran'
        AND column_name = 'post_processing_status'
    ) THEN
        ALTER TABLE ni_lms.`offline_tran`
        ADD COLUMN `post_processing_status` tinyint(2) NOT NULL DEFAULT '-1' COMMENT '-1:none required,0:all done,1:task required';
    END IF;

    IF NOT EXISTS (
        SELECT 1
        FROM information_schema.columns
        WHERE table_schema = 'ni_lms'
        AND table_name = 'offline_tran'
        AND column_name = 'transcoding_start_time'
    ) THEN
        ALTER TABLE ni_lms.`offline_tran`
        ADD COLUMN `transcoding_start_time` datetime NULL DEFAULT NULL;
    END IF;

    IF NOT EXISTS (
        SELECT 1
        FROM information_schema.columns
        WHERE table_schema = 'ni_lms'
        AND table_name = 'offline_tran'
        AND column_name = 'transcoding_end_time'
    ) THEN
        ALTER TABLE ni_lms.`offline_tran`
        ADD COLUMN `transcoding_end_time` datetime NULL DEFAULT NULL;
    END IF;

    IF EXISTS (
        SELECT 1
        FROM information_schema.columns
        WHERE table_schema = 'ni_lms'
        AND table_name = 'offline_tran'
        AND column_name = 'status'
        AND CHARACTER_MAXIMUM_LENGTH < 50
    ) THEN
        ALTER TABLE ni_lms.`offline_tran`
        MODIFY COLUMN `status` varchar(50) COMMENT 'deleted,running,completed,failed,queued,unknown,transcoding completed: post-processing failed,transcoding completed: post-processing';
    END IF;

    /* Add auto_increment id column to livetran_stream_playback_v3 if missing */
    IF NOT EXISTS (
        SELECT 1
        FROM information_schema.columns
        WHERE table_schema = 'ni_lms'
          AND table_name = 'livetran_stream_playback_v3'
          AND column_name = 'id'
    ) THEN
        ALTER TABLE ni_lms.`livetran_stream_playback_v3`
            ADD COLUMN `id` int(11) NOT NULL AUTO_INCREMENT UNIQUE FIRST;
    END IF;

    /* Ensure unique index on playback_id BEFORE changing primary key */
    IF NOT EXISTS (
        SELECT 1
        FROM information_schema.statistics
        WHERE table_schema = 'ni_lms'
          AND table_name = 'livetran_stream_playback_v3'
          AND index_name = 'idx_playback_id'
    ) THEN
        ALTER TABLE ni_lms.`livetran_stream_playback_v3`
            ADD UNIQUE KEY `idx_playback_id` (`playback_id`);
    END IF;

    /* Switch primary key from playback_id to id for livetran_stream_playback_v3 */
    IF EXISTS (
        SELECT 1
        FROM information_schema.statistics
        WHERE table_schema = 'ni_lms'
          AND table_name = 'livetran_stream_playback_v3'
          AND index_name = 'PRIMARY'
          AND column_name = 'playback_id'
    ) THEN
        ALTER TABLE ni_lms.`livetran_stream_playback_v3` DROP PRIMARY KEY;
    END IF;

    IF NOT EXISTS (
        SELECT 1
        FROM information_schema.statistics
        WHERE table_schema = 'ni_lms'
          AND table_name = 'livetran_stream_playback_v3'
          AND index_name = 'PRIMARY'
          AND column_name = 'id'
    ) THEN
        ALTER TABLE ni_lms.`livetran_stream_playback_v3` ADD PRIMARY KEY (`id`);
    END IF;

    /* Add auto_increment id column to livetran_stream_recording_v3 if missing */
    IF NOT EXISTS (
        SELECT 1
        FROM information_schema.columns
        WHERE table_schema = 'ni_lms'
          AND table_name = 'livetran_stream_recording_v3'
          AND column_name = 'id'
    ) THEN
        ALTER TABLE ni_lms.`livetran_stream_recording_v3`
            ADD COLUMN `id` int(11) NOT NULL AUTO_INCREMENT UNIQUE FIRST;
    END IF;

    /* Ensure unique index on recording_id BEFORE changing primary key */
    IF NOT EXISTS (
        SELECT 1
        FROM information_schema.statistics
        WHERE table_schema = 'ni_lms'
          AND table_name = 'livetran_stream_recording_v3'
          AND index_name = 'idx_recording_id'
    ) THEN
        ALTER TABLE ni_lms.`livetran_stream_recording_v3`
            ADD UNIQUE KEY `idx_recording_id` (`recording_id`);
    END IF;

    /* Switch primary key from recording_id to id for livetran_stream_recording_v3 */
    IF EXISTS (
        SELECT 1
        FROM information_schema.statistics
        WHERE table_schema = 'ni_lms'
          AND table_name = 'livetran_stream_recording_v3'
          AND index_name = 'PRIMARY'
          AND column_name = 'recording_id'
    ) THEN
        ALTER TABLE ni_lms.`livetran_stream_recording_v3` DROP PRIMARY KEY;
    END IF;

    IF NOT EXISTS (
        SELECT 1
        FROM information_schema.statistics
        WHERE table_schema = 'ni_lms'
          AND table_name = 'livetran_stream_recording_v3'
          AND index_name = 'PRIMARY'
          AND column_name = 'id'
    ) THEN
        ALTER TABLE ni_lms.`livetran_stream_recording_v3` ADD PRIMARY KEY (`id`);
    END IF;

    IF NOT EXISTS (
        SELECT 1
        FROM information_schema.columns
        WHERE table_schema = 'ni_lms'
        AND table_name = 'livetran_stream_v3'
        AND column_name = 'slate_state_json'
    ) THEN
        ALTER TABLE ni_lms.`livetran_stream_v3`
        ADD COLUMN `slate_state_json` text NULL DEFAULT NULL;
    END IF;

    IF NOT EXISTS (
        SELECT 1
        FROM information_schema.columns
        WHERE table_schema = 'ni_lms'
        AND table_name = 'livetran_capture_card'
        AND column_name = 'device_id'
    ) THEN
        /* First add the column */
        ALTER TABLE ni_lms.`livetran_capture_card`
        ADD COLUMN `device_id` varchar(1024) NOT NULL AFTER `id`;

        /* Mark existing records as needing device_id reassignment */
        UPDATE ni_lms.`livetran_capture_card`
        SET device_id = CONCAT('PLEASE REASSIGN', UUID());

        /* Drop the old unique constraint if it exists */
        IF EXISTS (
            SELECT 1
            FROM information_schema.statistics
            WHERE table_schema = 'ni_lms'
            AND table_name = 'livetran_capture_card'
            AND index_name = 'unique_card'
        ) THEN
            ALTER TABLE ni_lms.`livetran_capture_card`
            DROP INDEX `unique_card`;
        END IF;

        /* Drop the old virtual column if it exists */
        IF EXISTS (
            SELECT 1
            FROM information_schema.columns
            WHERE table_schema = 'ni_lms'
            AND table_name = 'livetran_capture_card'
            AND column_name = 'unique_hash'
        ) THEN
            ALTER TABLE ni_lms.`livetran_capture_card`
            DROP COLUMN `unique_hash`;
        END IF;

        /* Add the new virtual column and unique constraint */
        ALTER TABLE ni_lms.`livetran_capture_card`
        ADD COLUMN `unique_hash` char(32) GENERATED ALWAYS AS (MD5(CONCAT(`device_id`, `protocol`))) VIRTUAL,
        ADD CONSTRAINT `unique_card` UNIQUE (`unique_hash`) USING BTREE;
    END IF;

END$$

CREATE PROCEDURE `AddConstraintIfNotExists`()
BEGIN
    DECLARE constraint_exists INT DEFAULT 0;

    SELECT COUNT(*)
    INTO constraint_exists
    FROM information_schema.statistics
    WHERE table_schema = 'ni_lms'
    AND table_name = 'livetran_stream_origin'
    AND index_name = 'unique_output_stream_key';

    IF constraint_exists = 0 THEN
        ALTER TABLE ni_lms.`livetran_stream_origin` ADD CONSTRAINT `unique_output_stream_key` UNIQUE(`output_stream_key`, `region`);
    END IF;

    SELECT COUNT(*)
    INTO constraint_exists
    FROM information_schema.statistics
    WHERE table_schema = 'ni_lms'
    AND table_name = 'livetran_stream_v3'
    AND index_name = 'unique_stream_key_idx';

    IF constraint_exists = 0 THEN
        ALTER TABLE ni_lms.`livetran_stream_v3` ADD CONSTRAINT `unique_stream_key_idx` UNIQUE(`stream_key`, (CASE WHEN `status` != 0 THEN 1 ELSE NULL END));
    END IF;

    SELECT COUNT(*)
    INTO constraint_exists
    FROM information_schema.statistics
    WHERE table_schema = 'ni_lms'
    AND table_name = 'livetran_secrets'
    AND index_name = 'unique_name';

    IF constraint_exists = 0 THEN
        WITH ranked_dupes AS (
        SELECT
            id,
            user_id,
            name,
            ROW_NUMBER() OVER (PARTITION BY user_id, name ORDER BY id) AS rn
        FROM ni_lms.livetran_secrets
        )
        UPDATE ni_lms.livetran_secrets s
        JOIN ranked_dupes d ON s.id = d.id
        SET s.name = CONCAT(s.name, '_', d.rn-1)
        WHERE d.rn > 1;

        ALTER TABLE ni_lms.`livetran_secrets` ADD CONSTRAINT `unique_name` UNIQUE(`name`, `user_id`);
    END IF;
END$$

DROP PROCEDURE IF EXISTS `migrate_images`;
CREATE PROCEDURE `migrate_images`()
BEGIN
    IF EXISTS (
        SELECT 1
        FROM information_schema.tables
        WHERE table_schema = 'ni_nvs'
          AND table_name = 'livetran_image'
    )
    AND NOT EXISTS (
        SELECT 1 FROM ni_lms.livetran_image LIMIT 1
    ) THEN

        INSERT INTO ni_lms.livetran_image (
            user_id, organization_id, image_id, image_name,
            checksum, size, in_used, status, create_time, update_time
        )
        SELECT
            userid                            AS user_id,
            user_name_id                      AS organization_id,
            COALESCE(image_id, UUID())        AS image_id,
            image_name,
            checksum,
            size,
            COALESCE(in_used, 1)              AS in_used,
            status,
            create_time,
            update_time
        FROM ni_nvs.livetran_image;
    END IF;
END;

DROP PROCEDURE IF EXISTS `migrate_templates`;
CREATE PROCEDURE `migrate_templates`()
BEGIN
    IF EXISTS (
        SELECT 1
        FROM information_schema.tables
        WHERE table_schema = 'ni_nvs'
          AND table_name = 'livetran_template'
    )
    AND NOT EXISTS (
        SELECT 1 FROM ni_lms.livetran_template LIMIT 1
    ) THEN

        INSERT INTO ni_lms.livetran_template (
            user_id, organization_id, name, description, format, output, advanced_params,
            status, create_time, update_time
        )
        SELECT
            userid                            AS user_id,
            user_name_id                      AS organization_id,
            name, description,

            /* format column camel→snake */
            CASE
              WHEN format IS NULL OR format = '' OR JSON_VALID(format)=0
                   THEN '{"deinterlace_parity":"auto","deinterlace_mode":"send_frame"}'
              ELSE CAST(
                JSON_INSERT(
                    JSON_REMOVE(
                        JSON_SET(
                            CAST(format AS JSON),
                            '$.segment_duration',           JSON_EXTRACT(format,'$.segmentDuration'),
                            '$.rendition_structure',        JSON_EXTRACT(format,'$.renditionStructure'),
                            '$.hls_format',                 JSON_EXTRACT(format,'$.hlsFormat'),
                            '$.deinterlace_parity',         JSON_EXTRACT(format,'$.deinterlaceParity'),
                            '$.deinterlace_mode',           JSON_EXTRACT(format,'$.deinterlaceMode'),
                            '$.mpegts_null_stuffing',       JSON_EXTRACT(format,'$.mpegtsNullStuffing'),
                            '$.mpegts_null_stuffing_extra', JSON_EXTRACT(format,'$.mpegtsNullStuffingExtra'),
                            '$.segments_stored',
                            CASE
                                WHEN JSON_EXTRACT(format,'$.segmentWindows') IS NOT NULL THEN
                                /* Convert segmentWindows to segmentsStored */
                                GREATEST(
                                    2,
                                    FLOOR(
                                    CAST(JSON_EXTRACT(format,'$.segmentWindows') AS DECIMAL) /
                                    NULLIF(CAST(JSON_EXTRACT(format,'$.segmentDuration') AS DECIMAL), 0)
                                    )
                                )
                                ELSE CAST(JSON_EXTRACT(format,'$.segmentsStored') AS UNSIGNED)
                            END
                        ),
                        '$.gopSecond', '$.gopSize', '$.segmentDuration', '$.segmentsStored', '$.renditionStructure',
                        '$.hlsFormat', '$.deinterlaceParity','$.deinterlaceMode',
                        '$.limitInputCheckout','$.las','$.scaleRulesLm'
                    ),
                    '$.deinterlace_parity', 'auto',
                    '$.deinterlace_mode',   'send_frame',
                    '$.rendition_structure', 'multiple'
                ) AS CHAR CHARACTER SET utf8mb4
              )
            END AS format,

            /* output column camel→snake */
            CASE
              WHEN output IS NULL OR output = '' OR JSON_VALID(output)=0 THEN output
              ELSE CAST(
                REPLACE(REPLACE(REPLACE(REPLACE(
                    JSON_REMOVE(
                        JSON_SET(
                            CAST(output AS JSON),
                            '$.default_audio_lang', JSON_EXTRACT(output,'$.defaultAudioLang'),
                            '$.set_logo',           JSON_EXTRACT(output,'$.setLogo'),
                            '$.logo.img_id',        JSON_EXTRACT(output,'$.logo.imgId'),
                            '$.logo.location_type', JSON_EXTRACT(output,'$.logo.locationType')
                        ),
                        '$.defaultAudioLang', '$.setLogo', '$.logo.imgId', '$.logo.locationType'
                    ),
                    '"captureCardFormat":', '"capture_card_format":'),
                    '"enableTranscription":', '"enable_transcription":'),
                    '"defaultLanguage":', '"default_language":'),
                    '"inputIndex":', '"input_index":'
                ) AS CHAR CHARACTER SET utf8mb4
            )
            END AS output,

            /* advanced_params column camel→snake */
            CASE
              WHEN senior_params IS NULL OR senior_params = '' OR JSON_VALID(senior_params)=0 THEN senior_params
              ELSE CAST(
                    JSON_REMOVE(
                        JSON_SET(
                            CAST(senior_params AS JSON),
                            '$.quadra.encoder_params',                   JSON_EXTRACT(senior_params,'$.quadra.encoderParams'),
                            '$.quadra.decoder_params',                   JSON_EXTRACT(senior_params,'$.quadra.decoderParams'),
                            '$.quadra.custom_vpu_xcoder_params_enable',  JSON_EXTRACT(senior_params,'$.quadra.customVpuXcoderParamsEnable'),
                            '$.quadra.custom_vpu_xcoder_params',         JSON_EXTRACT(senior_params,'$.quadra.customVpuXcoderParams'),
                            '$.quadra.encoder_params.gop_preset_idx',    JSON_EXTRACT(senior_params,'$.quadra.encoderParams.gopPresetIdx'),
                            '$.quadra.encoder_params.enable_lookahead',
                                CASE
                                    WHEN CAST(JSON_EXTRACT(senior_params,'$.quadra.encoderParams.enableLookahead') AS UNSIGNED)=1
                                    THEN TRUE ELSE FALSE END,
                            '$.quadra.encoder_params.lookahead_depth',   JSON_EXTRACT(senior_params,'$.quadra.encoderParams.lookaheadDepth'),
                            '$.quadra.encoder_params.enable_rdo_quant',
                                CASE
                                    WHEN CAST(JSON_EXTRACT(senior_params,'$.quadra.encoderParams.enableRdoQuant') AS UNSIGNED)=1
                                    THEN TRUE ELSE FALSE END,
                            '$.quadra.encoder_params.rdo_level',         JSON_EXTRACT(senior_params,'$.quadra.encoderParams.rdoLevel')
                        ),
                        '$.quadra.encoderParams','$.quadra.decoderParams',
                        '$.quadra.customVpuXcoderParamsEnable', '$.quadra.customVpuXcoderParams'
                    ) AS CHAR CHARACTER SET utf8mb4
              )
            END AS advanced_params,

            status,
            create_time,
            update_time
        FROM ni_nvs.livetran_template;

    END IF;
END$$

CREATE PROCEDURE `UpsertTemplate`(
    IN p_user_id INT,
    IN p_organization_id INT,
    IN p_name VARCHAR(255),
    IN p_description VARCHAR(255),
    IN p_format VARCHAR(2048),
    IN p_output TEXT,
    IN p_advanced_params VARCHAR(4096)
)
BEGIN
    DECLARE template_count INT;

    SELECT COUNT(*) INTO template_count
    FROM ni_lms.livetran_template
    WHERE name = p_name AND user_id = p_user_id AND organization_id = p_organization_id AND status = 1;

    IF template_count > 0 THEN
        UPDATE ni_lms.livetran_template
        SET
            description = p_description,
            format = p_format,
            output = p_output,
            advanced_params = p_advanced_params,
            status = 1,
            update_time = NOW()
        WHERE name = p_name AND status = 1 AND user_id = p_user_id AND organization_id = p_organization_id;
    ELSE
        INSERT INTO ni_lms.livetran_template (
            user_id, organization_id, name, description, format, output,
            advanced_params, status, create_time, update_time
        ) VALUES (
            p_user_id, p_organization_id, p_name, p_description, p_format, p_output,
            p_advanced_params, 1, NOW(), NOW()
        );
    END IF;
END$$

CREATE PROCEDURE UpdatePlaybackRegion(IN region_name VARCHAR(255))
BEGIN
    DECLARE done INT DEFAULT FALSE;
    DECLARE row_id BIGINT;
    DECLARE i INT;
    DECLARE arr_length INT;

    DECLARE cur CURSOR FOR SELECT id FROM ni_lms.livetran_stream_v3;
    DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = TRUE;

    OPEN cur;

    read_loop: LOOP
        FETCH cur INTO row_id;
        IF done THEN
            LEAVE read_loop;
        END IF;

        SET arr_length = JSON_LENGTH(
            (SELECT playback_settings FROM ni_lms.livetran_stream_v3 WHERE id=row_id)
        );
        IF arr_length IS NULL THEN
            SET arr_length = 0;
        END IF;

        SET i = 0;
        WHILE i < arr_length DO
            UPDATE ni_lms.livetran_stream_v3
            SET playback_settings = JSON_SET(
                playback_settings,
                CONCAT('$[', i, '].output_urls[0].region'), region_name
            )
            WHERE id = row_id;
            SET i = i + 1;
        END WHILE;

    END LOOP;

    CLOSE cur;
END$$

DROP PROCEDURE IF EXISTS `UpsertImage`;
CREATE PROCEDURE `UpsertImage`(
    IN p_userid INT,
    IN p_organization_id INT,
    IN p_image_id VARCHAR(100),
    IN p_image_name VARCHAR(255),
    IN p_checksum VARCHAR(50),
    IN p_size INT,
    OUT o_image_record_id INT
)
BEGIN
    DECLARE image_count INT;
    DECLARE existing_id INT;

    SELECT COUNT(*), MAX(id) INTO image_count, existing_id
    FROM ni_lms.livetran_image
    WHERE image_name = p_image_name AND user_id = p_userid AND organization_id = p_organization_id AND status = 1;

    IF image_count > 0 THEN
        UPDATE ni_lms.livetran_image
        SET
            image_id = p_image_id,
            checksum = p_checksum,
            size = p_size,
            status = 1,
            update_time = NOW()
        WHERE id = existing_id;

        SET o_image_record_id = existing_id;
    ELSE
        INSERT INTO ni_lms.livetran_image (
            user_id, organization_id, image_id, image_name,
            checksum, size, in_used, status, create_time, update_time
        ) VALUES (
            p_userid, p_organization_id, p_image_id, p_image_name,
            p_checksum, p_size, 1, 1, NOW(), NOW()
        );

        SET o_image_record_id = LAST_INSERT_ID();
    END IF;
END$$

DELIMITER ;

/* Alter table statements */
CALL `AddColumnIfNotExists`();
DROP PROCEDURE `AddColumnIfNotExists`;
CALL `AddConstraintIfNotExists`();
DROP PROCEDURE `AddConstraintIfNotExists`;

CALL `migrate_images`();
CALL `migrate_templates`();

ALTER TABLE ni_user.`livetran_user` MODIFY COLUMN `expiry_date` int(11) NULL NULL DEFAULT '0' COMMENT 'expiry time';

ALTER TABLE ni_notification.`livetran_domain` MODIFY COLUMN `domain` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL AFTER `user_name_id`;

/* Upsert default image */
CALL `UpsertImage`(73464625, 7000, 'b69100ebf7cd43a586c98e92e2589b88', 'image59588888_20250108161544.png', '2b6c39c88226d3ee3a59658be7de3d28', 16340, @image_id);

CALL `UpsertTemplate`(73464625, 7000, 'Example_High_Quality-H.264', 'H.264 5x Output Encoding Ladder 1080p-720p-540p-360p-270p',
'{\"segment_duration\":2,\"segments_stored\":15,\"rendition_structure\":\"multiple\",\"hls_format\":\"fmp4\",\"deinterlace_parity\":\"auto\",\"deinterlace_mode\":\"send_frame\",\"mpegts_null_stuffing\":false,\"mpegts_null_stuffing_extra\":0,\"mpegts_tv_system\":\"dvb\",\"enable_hls_combined_audio\":false}',
CONCAT('{\"video\":[{\"codec\":\"h264\",\"bitrate\":4755,\"fps\":30,\"width\":1920,\"height\":1080},{\"codec\":\"h264\",\"bitrate\":2516,\"fps\":30,\"width\":1280,\"height\":720},{\"codec\":\"h264\",\"bitrate\":1640,\"fps\":30,\"width\":960,\"height\":540},{\"codec\":\"h264\",\"bitrate\":990,\"fps\":30,\"width\":640,\"height\":360},{\"codec\":\"h264\",\"bitrate\":697,\"fps\":30,\"width\":480,\"height\":270}],\"audio\":[],\"logo\":[{\"img_id\":\"', @image_id, '\",\"location_type\":\"pixel\",\"location\":\"\",\"x\":1710,\"y\":10}],\"default_audio_lang\":\"und\",\"version\":1,\"set_logo\":true,\"webvtt\":{\"enabled\":false,\"language\":\"\",\"priority\":\"teletext\"},\"global_audio_level_control\":{\"enabled\":false,\"integrated_loudness\":-24.0,\"loudness_range\":7.0,\"true_peak\":-2.0}}'),
'{\"quadra\":{\"encoder_params\":{\"gop_preset_idx\":8,\"enable_lookahead\":1,\"lookahead_depth\":4,\"enable_rdo_quant\":0,\"rdo_level\":1,\"frame_rate_handling\":\"capped\",\"enable_timecode_passthru\":false},\"decoder_params\":{},\"filter_params\":{\"hw_scale_mode\":\"auto\"},\"custom_vpu_xcoder_params_enable\":false,\"custom_vpu_xcoder_params\":\"\"}}');

CALL `UpsertTemplate`(73464625, 7000, 'Example_High_Quality-H.265', 'H.265 5x Output Encoding Ladder 1080p-720p-540p-360p-270p',
'{\"segment_duration\":2,\"segments_stored\":15,\"rendition_structure\":\"multiple\",\"hls_format\":\"fmp4\",\"deinterlace_parity\":\"auto\",\"deinterlace_mode\":\"send_frame\",\"mpegts_null_stuffing\":false,\"mpegts_null_stuffing_extra\":0,\"mpegts_tv_system\":\"dvb\",\"enable_hls_combined_audio\":false}',
CONCAT('{\"video\":[{\"codec\":\"h265\",\"bitrate\":3328,\"fps\":30,\"width\":1920,\"height\":1080},{\"codec\":\"h265\",\"bitrate\":1761,\"fps\":30,\"width\":1280,\"height\":720},{\"codec\":\"h265\",\"bitrate\":1148,\"fps\":30,\"width\":960,\"height\":540},{\"codec\":\"h265\",\"bitrate\":693,\"fps\":30,\"width\":640,\"height\":360},{\"codec\":\"h265\",\"bitrate\":500,\"fps\":30,\"width\":480,\"height\":270}],\"audio\":[],\"logo\":[{\"img_id\":\"', @image_id, '\",\"location_type\":\"pixel\",\"location\":\"\",\"x\":1710,\"y\":10}],\"default_audio_lang\":\"und\",\"version\":1,\"set_logo\":true,\"webvtt\":{\"enabled\":false,\"language\":\"\",\"priority\":\"teletext\"},\"global_audio_level_control\":{\"enabled\":false,\"integrated_loudness\":-24.0,\"loudness_range\":7.0,\"true_peak\":-2.0}}'),
'{\"quadra\":{\"encoder_params\":{\"gop_preset_idx\":8,\"enable_lookahead\":1,\"lookahead_depth\":4,\"enable_rdo_quant\":0,\"rdo_level\":1,\"frame_rate_handling\":\"capped\",\"enable_timecode_passthru\":false},\"decoder_params\":{},\"filter_params\":{\"hw_scale_mode\":\"auto\"},\"custom_vpu_xcoder_params_enable\":false,\"custom_vpu_xcoder_params\":\"\"}}');

DROP PROCEDURE `UpsertTemplate`;

/* Update hlsFormat from 'ts' to 'fmp4' for H.265 and AV1 codecs */
UPDATE ni_lms.`livetran_template`
    SET format = JSON_SET(
        format,
        '$.hls_format',
        'fmp4'
    )
    WHERE format LIKE '%"hls_format":"ts"%'
        AND output LIKE '%"video":%'
        AND (
            output LIKE '%"codec":"h265"%'
            OR output LIKE '%"codec":"av1"%'
        );

/* Update enable_lookahead and enable_rdo_quant to JSON boolean */
UPDATE ni_lms.livetran_template
SET advanced_params = JSON_SET(
        advanced_params,
        '$.quadra.encoder_params.enable_lookahead',
          IF(
            CAST(
              JSON_UNQUOTE(
                JSON_EXTRACT(advanced_params,'$.quadra.encoder_params.enable_lookahead')
              ) AS UNSIGNED
            ) = 1,
            CAST('true'  AS JSON),
            CAST('false' AS JSON)
          ),
        '$.quadra.encoder_params.enable_rdo_quant',
          IF(
            CAST(
              JSON_UNQUOTE(
                JSON_EXTRACT(advanced_params,'$.quadra.encoder_params.enable_rdo_quant')
              ) AS UNSIGNED
            ) = 1,
            CAST('true'  AS JSON),
            CAST('false' AS JSON)
          )
    )
WHERE JSON_VALID(advanced_params) = 1
  AND (
        JSON_TYPE(JSON_EXTRACT(advanced_params,'$.quadra.encoder_params.enable_lookahead')) IN ('INTEGER','STRING')
     OR JSON_TYPE(JSON_EXTRACT(advanced_params,'$.quadra.encoder_params.enable_rdo_quant')) IN ('INTEGER','STRING')
  );



UPDATE ni_lms.livetran_stream_v3 SET regions='["Bitstreams"]' WHERE regions!='["Bitstreams"]';
UPDATE ni_lms.livetran_stream_v3 SET input_settings = JSON_SET(input_settings, '$.input_urls[0].region', 'Bitstreams');
UPDATE ni_lms.livetran_stream_output_status_v3 SET region='Bitstreams' WHERE region!='Bitstreams';
UPDATE ni_lms.livetran_stream_source_status_v3 SET region='Bitstreams' WHERE region!='Bitstreams';
DELETE from ni_lms.livetran_networking_settings where region != "Bitstreams";
UPDATE ni_nvs.livetran_task_v2 SET region='Bitstreams' WHERE region!='Bitstreams';

CALL UpdatePlaybackRegion('Bitstreams');
DROP PROCEDURE UpdatePlaybackRegion;

/* Update default user info for current product*/
source ./default_users.sql
