/* Create table statements for all services */

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

CREATE DATABASE IF NOT EXISTS `ni_lms`;
CREATE DATABASE IF NOT EXISTS `ni_nvs`;
CREATE DATABASE IF NOT EXISTS `ni_user`;
CREATE DATABASE IF NOT EXISTS `ni_notification`;

/* ni_lms */
CREATE TABLE IF NOT EXISTS ni_lms.`livetran_asset` (
    `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id',
    `userid` int(11) NOT NULL DEFAULT '0' COMMENT 'userid',
    `user_name_id` int(11) NOT NULL DEFAULT '0' COMMENT 'user name id',
    `app` varchar(255) NOT NULL DEFAULT '' COMMENT 'app',
    `event_id` varchar(255) NOT NULL DEFAULT '',
    `asset_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'asset id',
    `taskid` varchar(50) NOT NULL DEFAULT '' COMMENT 'task id',
    `stream_id` varchar(255) NOT NULL DEFAULT '',
    `stream_key` varchar(255) NOT NULL DEFAULT '' COMMENT 'stream key',
    `stream_key_md5` varchar(50) NOT NULL DEFAULT '' COMMENT 'stream key md5',
    `output_stream_key` varchar(255) NOT NULL DEFAULT '' COMMENT 'output stream key',
    `output_stream_key_md5` varchar(50) NOT NULL DEFAULT '' COMMENT 'output stream key md5',
    `type` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0:hls,1:dash,2:image',
    `asset_path` varchar(512) NOT NULL DEFAULT '' COMMENT 'asset path',
    `asset_name` varchar(512) NOT NULL DEFAULT '' COMMENT 'asset name',
    `duration` float NOT NULL DEFAULT 0,
    `expiration` INT(10) NOT NULL DEFAULT 0 COMMENT 'record expiration time',
    `max_rate` float NOT NULL DEFAULT 0,
    `max_resolution` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '0',
    `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT '0:deleted,1:ok',
    `create_time` datetime NOT NULL COMMENT 'create time',
    `update_time` datetime NOT NULL COMMENT 'update time',
    PRIMARY KEY (`id`),
    INDEX `idx_stream`(`stream_key_md5`, `status`) USING BTREE,
    INDEX `idx_u`(`userid`, `user_name_id`, `app`, `stream_key_md5`) USING BTREE,
    INDEX `idx_output_stream`(`output_stream_key_md5`, `status`) USING BTREE
    ) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS ni_lms.`livetran_asset_playback` (
    `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
    `asset_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'asset id',
    `playback_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'playback id',
    `playback_id_md5` varchar(50) NOT NULL DEFAULT '' COMMENT 'playback id md5',
    `policy` varchar(10) NOT NULL DEFAULT '' COMMENT 'policy',
    `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT '0:deleted,1:ok',
    `create_time` datetime NOT NULL COMMENT 'create time',
    `update_time` datetime NOT NULL COMMENT 'update time',
    PRIMARY KEY (`id`),
    KEY `idx_playback` (`playback_id_md5`) USING BTREE,
    KEY `idx_tid` (`asset_id`)
    ) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS ni_lms. `livetran_stream` (
    `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id',
    `userid` int(11) NOT NULL DEFAULT '0' COMMENT 'userid',
    `user_name_id` int(11) NOT NULL DEFAULT '0' COMMENT 'user name id',
    `app` varchar(255) NOT NULL DEFAULT '' COMMENT 'app',
    `env_id` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'env id',
    `stream_id` varchar(50) NOT NULL DEFAULT '' COMMENT 'stream id',
    `stream_key` varchar(255) NOT NULL DEFAULT '' COMMENT 'stream key',
    `transcode_type` tinyint(4) NOT NULL DEFAULT '1' COMMENT 'transcode type 1:push,2:pull',
    `description` varchar(255) NULL DEFAULT NULL COMMENT 'description',
    `playbacks` text NOT NULL COMMENT 'playbacks information',
    `templates` varchar(1024) NOT NULL DEFAULT '' COMMENT 'customized template name',
    `reconnect_window` int(11) NOT NULL DEFAULT '60' COMMENT 'reconnect window,default:60,max:1800',
    `audio_only` tinyint(4) NOT NULL DEFAULT '0' COMMENT '1:true,0:false',
    `max_continuous_duration` int(11) NOT NULL DEFAULT '300' COMMENT 'file duration,max:43200,min:60,default:300',
    `multirate_to_templates` varchar(1024) DEFAULT '' COMMENT 'multi-bitrate template',
    `ext_param` text COMMENT 'extra parameters',
    `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT '0:deleted,1:idle,2:active,3:disabled,4:disconnected',
    `create_time` datetime DEFAULT NULL COMMENT 'create time',
    `update_time` datetime DEFAULT NULL COMMENT 'update time',
    PRIMARY KEY (`id`),
    KEY `idx_u` (`userid`,`user_name_id`,`status`,`env_id`) USING BTREE,
    KEY `idx_sid` (`stream_id`,`status`,`env_id`),
    KEY `idx_skey` (`status`,`stream_key`,`env_id`) USING BTREE
    ) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS ni_lms.`livetran_stream_v2` (
    `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id',
    `userid` int(11) NOT NULL DEFAULT '0' COMMENT 'user id',
    `user_name_id` int(11) NOT NULL DEFAULT '0' COMMENT 'user name id',
    `regions` varchar(256) DEFAULT NULL COMMENT 'regions',
    `app` varchar(255) NOT NULL DEFAULT '' COMMENT 'app',
    `env_id` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'env id',
    `stream_id` varchar(50) NOT NULL DEFAULT '' COMMENT 'stream id',
    `stream_key` varchar(255) NOT NULL DEFAULT '' COMMENT 'stream key',
    `transcode_type` tinyint(4) NOT NULL DEFAULT '1' COMMENT 'transcode type 1:push,2:pull',
    `description` varchar(255) DEFAULT NULL COMMENT 'description',
    `streaming_settings` text NOT NULL COMMENT 'streaming settings',
    `templates` varchar(1024) NOT NULL DEFAULT '["default"]' COMMENT 'customized template name',
    `reconnect_interval` int(11) NOT NULL DEFAULT '60' COMMENT 'reconnect window,default:60,max:1800',
    `max_file_duration` int(11) NOT NULL DEFAULT '300' COMMENT 'file duration,max:43200,min:60,default:300',
    `multirate_to_templates` varchar(1024) DEFAULT '' COMMENT 'multi-bitrate template',
    `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT '0:deleted,1:idle,2:active,3:disabled,4:disconnected',
    `create_time` datetime DEFAULT NULL COMMENT 'create time',
    `update_time` datetime DEFAULT NULL COMMENT 'update time',
    `ext_param` text COMMENT 'extra parameters',
    PRIMARY KEY (`id`),
    KEY `idx_u` (`userid`,`user_name_id`,`status`,`env_id`) USING BTREE,
    KEY `idx_sid` (`stream_id`,`status`,`env_id`),
    KEY `idx_skey` (`status`,`stream_key`,`env_id`) USING BTREE
    ) ENGINE=InnoDB AUTO_INCREMENT=10374 DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS ni_lms.`livetran_stream_event`  (
    `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id',
    `stream_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'stream id',
    `event_id` varchar(50) NULL DEFAULT '' COMMENT 'event id',
    `ext_param` text NOT NULL COMMENT 'extra parameters',
    `version` int(11) NULL DEFAULT 0 COMMENT 'version used by optimistic locking',
    `create_time` datetime NULL DEFAULT NULL COMMENT 'create time',
    `update_time` datetime NULL DEFAULT NULL COMMENT 'update time',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_sid`(`stream_id`) USING BTREE
    ) ENGINE = InnoDB AUTO_INCREMENT = 21 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

CREATE TABLE IF NOT EXISTS ni_lms.`livetran_stream_playback` (
    `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
    `stream_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'stream id',
    `playback_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'playback id',
    `playback_id_md5` varchar(50) NOT NULL DEFAULT '' COMMENT 'playback id md5',
    `policy` varchar(10) NOT NULL DEFAULT '' COMMENT 'policy',
    `playbacks_index` tinyint(8) NOT NULL DEFAULT '0' COMMENT 'playback index',
    `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT '0:deleted,1:ok',
    `create_time` datetime NOT NULL COMMENT 'create time',
    `update_time` datetime NOT NULL COMMENT 'update time',
    PRIMARY KEY (`id`),
    KEY `idx_playback` (`playback_id_md5`) USING BTREE,
    KEY `idx_tid` (`stream_id`) USING BTREE
    ) ENGINE=InnoDB AUTO_INCREMENT=61 DEFAULT CHARSET=utf8mb4;

CREATE TABLE  IF NOT EXISTS ni_lms.`livetran_stream_playback_v2` (
    `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
    `stream_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'stream id',
    `playback_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'playback id',
    `playback_id_md5` varchar(50) NOT NULL DEFAULT '' COMMENT 'playback id md5',
    `policy` varchar(10) NOT NULL DEFAULT '' COMMENT 'policy',
    `playbacks_index` tinyint(8) NOT NULL DEFAULT '0' COMMENT 'playback index',
    `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT '0:deleted,1:ok',
    `create_time` datetime NOT NULL COMMENT 'create time',
    `update_time` datetime NOT NULL COMMENT 'update time',
    PRIMARY KEY (`id`),
    KEY `idx_playback` (`playback_id_md5`) USING BTREE,
    KEY `idx_tid` (`stream_id`) USING BTREE
    ) ENGINE=InnoDB AUTO_INCREMENT=11621 DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS ni_lms.`livetran_stream_state_output`  (
    `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id',
    `region` varchar(20) NOT NULL COMMENT 'region information',
    `stream_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'stream id',
    `event_id` varchar(50) NOT NULL DEFAULT '' COMMENT 'event id',
    `taskid` varchar(50) NOT NULL DEFAULT '' COMMENT 'task id',
    `output_stream_key` varchar(255) NOT NULL DEFAULT '' COMMENT 'output stream key',
    `output_stream_key_md5` varchar(50) NOT NULL DEFAULT '' COMMENT 'output stream key md5',
    `playbacks_index` tinyint(8) NOT NULL DEFAULT 0 COMMENT 'playback index',
    `output` text NOT NULL COMMENT 'output stream information',
    `create_time` datetime NOT NULL COMMENT 'create time',
    `update_time` datetime NOT NULL COMMENT 'update time',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_tid`(`taskid`, `region`) USING BTREE,
    INDEX `idx_osk`(`output_stream_key_md5`, `region`) USING BTREE,
    INDEX `idx_sid`(`stream_id`, `region`, `event_id`) USING BTREE
    ) ENGINE = InnoDB AUTO_INCREMENT = 135 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = 'transcode streams state table' ROW_FORMAT = DYNAMIC;

CREATE TABLE IF NOT EXISTS ni_lms.`livetran_stream_state_source`  (
    `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id',
    `region` varchar(20) NOT NULL COMMENT 'region information',
    `stream_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'stream id',
    `event_id` varchar(50) NOT NULL DEFAULT '' COMMENT 'event id',
    `source` text NOT NULL COMMENT 'source stream information',
    `status` tinyint(4) NOT NULL DEFAULT 1 COMMENT '5:stopped,1:idle,2:active,3:disabled,4:disconnected',
    `create_time` datetime NULL DEFAULT NULL COMMENT 'create time',
    `update_time` datetime NULL DEFAULT NULL COMMENT 'update time',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_tid`(`region`) USING BTREE,
    INDEX `idx_osk`(`region`) USING BTREE,
    INDEX `idx_sid`(`stream_id`, `region`, `event_id`) USING BTREE
    ) ENGINE = InnoDB AUTO_INCREMENT = 113 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = 'live streams state table' ROW_FORMAT = DYNAMIC;

CREATE TABLE IF NOT EXISTS ni_lms.`livetran_record` (
    `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id',
    `userid` int(11) NOT NULL DEFAULT '0' COMMENT 'user id',
    `user_name_id` int(11) NOT NULL DEFAULT '0' COMMENT 'user name id',
    `app` varchar(255) NOT NULL DEFAULT '' COMMENT 'app',
    `event_id` varchar(255) NOT NULL DEFAULT '',
    `record_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'record id',
    `taskid` varchar(50) NOT NULL DEFAULT '' COMMENT 'task id',
    `stream_id` varchar(255) NOT NULL DEFAULT '',
    `stream_key` varchar(255) NOT NULL DEFAULT '' COMMENT 'stream key',
    `stream_key_md5` varchar(50) NOT NULL DEFAULT '' COMMENT 'stream key md5',
    `output_stream_key` varchar(255) NOT NULL DEFAULT '' COMMENT 'output stream key',
    `output_stream_key_md5` varchar(50) NOT NULL DEFAULT '' COMMENT 'output stream key md5',
    `type` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0:hls,1:dash,2image',
    `record_path` varchar(512) NOT NULL DEFAULT '' COMMENT 'record path',
    `record_name` varchar(512) NOT NULL DEFAULT '' COMMENT 'record name',
    `duration` float NOT NULL DEFAULT '0',
    `expiration` int(10) NOT NULL DEFAULT '0' COMMENT 'record expiration time',
    `max_rate` float NOT NULL DEFAULT '0',
    `max_resolution` varchar(50) NOT NULL DEFAULT '0',
    `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT '0:deleted,1:ok',
    `create_time` datetime NOT NULL COMMENT 'create time',
    `update_time` datetime NOT NULL COMMENT 'update time',
    PRIMARY KEY (`id`),
    KEY `idx_stream` (`stream_key_md5`,`status`) USING BTREE,
    KEY `idx_u` (`userid`,`user_name_id`,`app`,`stream_key_md5`) USING BTREE,
    KEY `idx_output_stream` (`output_stream_key_md5`,`status`) USING BTREE,
    KEY `idx_rid_sts`(`status`, `record_id`) USING BTREE
    ) ENGINE=InnoDB AUTO_INCREMENT=203 DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS ni_lms.`livetran_record_playback` (
    `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
    `record_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'record id',
    `playback_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'playback id',
    `playback_id_md5` varchar(50) NOT NULL DEFAULT '' COMMENT 'playback id md5',
    `policy` varchar(10) NOT NULL DEFAULT '' COMMENT 'policy',
    `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT '0:deleted,1:ok',
    `create_time` datetime NOT NULL COMMENT 'create time',
    `update_time` datetime NOT NULL COMMENT 'update time',
    PRIMARY KEY (`id`),
    KEY `idx_playback` (`playback_id_md5`) USING BTREE,
    KEY `idx_tid` (`record_id`)
    ) ENGINE=InnoDB AUTO_INCREMENT=296 DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS ni_lms.`livetran_license` (
    `id` int(10) NOT NULL AUTO_INCREMENT,
    `license_info` longtext COMMENT 'license info',
    `running_condition` longtext,
    `create_time` datetime NOT NULL,
    `update_time` datetime NOT NULL,
    `deleted` int(2) unsigned NOT NULL COMMENT '0 in use, 1 deleted',
    PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS ni_lms.`livetran_origin` (
    `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
    `playback_host` varchar(512) NOT NULL,
    `config_json` varchar(1024) NOT NULL,
    `load` int(11) NOT NULL,
    `status` tinyint(4) NOT NULL,
    `region` varchar(20) NOT NULL,
    PRIMARY KEY (`id`),
    UNIQUE (`playback_host`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS ni_lms.`livetran_stream_origin` (
    `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
    `playback_host` varchar(512) NOT NULL,
    `output_stream_key` varchar(255) NOT NULL,
    `num_output_streams` int(11) NOT NULL,
    `region` varchar(20) NOT NULL,
    `origin_config_json` varchar(1024) NOT NULL,
    PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

/* ni_nvs */
CREATE TABLE IF NOT EXISTS ni_nvs.`livetran_send_rule` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `rule_type` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'rule type 0:default,1:userid,2:stream,3:tworker',
    `task_type` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'task type',
    `userid` int(11) NOT NULL DEFAULT '0' COMMENT 'user id',
    `user_name_id` int(11) NOT NULL DEFAULT '0' COMMENT 'user name id',
    `app` varchar(255) NOT NULL DEFAULT '' COMMENT 'app',
    `stream_name` varchar(255) NOT NULL DEFAULT '' COMMENT 'stream key',
    `tworker_names` text NOT NULL COMMENT 'tworker names',
    `tworker_type` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0:all tasks,1:specific tasks only',
    `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0:deleted,1:ok',
    `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'create time',
    `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'update time',
    PRIMARY KEY (`id`) USING BTREE
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS ni_nvs.`livetran_task` (
    `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id',
    `userid` int(11) NOT NULL DEFAULT '0' COMMENT 'user id',
    `user_name_id` int(11) NOT NULL DEFAULT '0' COMMENT 'user name id',
    `app` varchar(255) NOT NULL DEFAULT '' COMMENT 'app',
    `env_id` tinyint(8) NOT NULL DEFAULT '0' COMMENT 'env id 0:dev,1:prod',
    `task_type` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'task type',
    `taskid` varchar(255) NOT NULL DEFAULT '' COMMENT 'task id',
    `event_id` varchar(50) NULL DEFAULT NULL COMMENT 'event id',
    `template` varchar(255) NOT NULL DEFAULT '' COMMENT 'template',
    `stream_name` varchar(255) NOT NULL DEFAULT '' COMMENT 'stream key',
    `stream_name_md5` varchar(40) NOT NULL DEFAULT '' COMMENT 'stream keymd5',
    `source` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0:internal source,1:external source',
    `region` varchar(20) NOT NULL DEFAULT '' COMMENT 'region information',
    `input_url` varchar(1024) NOT NULL DEFAULT '' COMMENT 'input url',
    `input_url_md5` varchar(40) NOT NULL DEFAULT '' COMMENT 'input url md5',
    `app_stream` varchar(255) NOT NULL COMMENT 'input url app/stream path',
    `app_stream_md5` varchar(255) NOT NULL DEFAULT '' COMMENT 'input url app/stream path md5',
    `output_format` text NOT NULL COMMENT 'output format:json',
    `ext_param` text NOT NULL COMMENT 'extra parameters',
    `tworker_info` varchar(255) NOT NULL DEFAULT '' COMMENT 'tworker information',
    `tworker_host` varchar(255) NOT NULL DEFAULT '' COMMENT 'tworker hostname',
    `error_code` int(11) NOT NULL DEFAULT '0' COMMENT 'error code',
    `error_reason` varchar(100) NOT NULL DEFAULT '' COMMENT 'error reason',
    `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0:exit,1:in progress,2:exit with error,3:waiting for re-push',
    `last_charge_time` int(11) NOT NULL DEFAULT '0' COMMENT 'last charge timestamp',
    `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'create time',
    `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'update time',
    PRIMARY KEY (`id`) USING BTREE,
    KEY `idx_tid` (`taskid`,`status`) USING BTREE,
    KEY `idx_ss` (`stream_name_md5`,`status`) USING BTREE,
    KEY `idx_ct` (`status`,`create_time`) USING BTREE,
    KEY `idx_uuas` (`userid`,`status`,`app_stream_md5`) USING BTREE
    ) ENGINE=InnoDB AUTO_INCREMENT=73 DEFAULT CHARSET=utf8mb4 COMMENT='task information table';

CREATE TABLE IF NOT EXISTS ni_nvs.`livetran_task_cron` (
    `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id',
    `region` varchar(20) NULL DEFAULT '' COMMENT 'region information',
    `taskid` varchar(255) NOT NULL DEFAULT '' COMMENT 'task id',
    `action_type` tinyint(4) NOT NULL DEFAULT '0' COMMENT '1:start,2:stop,3:update',
    `action_time_type` tinyint(4) NOT NULL DEFAULT '0' COMMENT '1:act once,2:act daily',
    `action_time` varchar(50) NOT NULL DEFAULT '' COMMENT 'action timestamp',
    `entry_ids` varchar(250) NOT NULL DEFAULT '' COMMENT 'task ids each machine',
    `created_machine_id` varchar(50) NOT NULL DEFAULT '' COMMENT 'create machine id',
    `run_machine_id` varchar(50) NOT NULL DEFAULT '' COMMENT 'run machine id',
    `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0:deleted,1:success,2:wait,3:fail,4:no execution,5:fail to create',
    `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'create time',
    `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'update time',
    PRIMARY KEY (`id`) USING BTREE,
    KEY `idx_tid` (`taskid`,`action_type`,`action_time_type`,`status`) USING BTREE COMMENT 'taskid',
    KEY `idx_status` (`action_time`,`status`) USING BTREE COMMENT 'status'
    ) ENGINE=InnoDB AUTO_INCREMENT=67 DEFAULT CHARSET=utf8mb4 COMMENT='task-related cron table';

CREATE TABLE IF NOT EXISTS ni_nvs.`livetran_template` (
    `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id',
    `userid` int(11) NOT NULL DEFAULT '0' COMMENT 'user id',
    `user_name_id` int(11) NOT NULL DEFAULT '0' COMMENT 'user name id',
    `app` varchar(255) NOT NULL DEFAULT '' COMMENT 'app',
    `env_id` tinyint(8) NOT NULL DEFAULT '0' COMMENT 'env id 0:dev,1:prod',
    `name` varchar(128) NOT NULL DEFAULT '' COMMENT 'template name',
    `type` varchar(20) NOT NULL DEFAULT '' COMMENT 'type',
    `description` varchar(255) NOT NULL DEFAULT '' COMMENT 'description',
    `mutil_bitrate_type` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'is multi-bitrate',
    `format` varchar(2048) NOT NULL COMMENT 'basic format parameters',
    `output` text NOT NULL COMMENT 'output stream information',
    `senior_params` varchar(4096) NOT NULL DEFAULT '' COMMENT 'specific parameters',
    `ext_param` text NULL COMMENT 'extra parameters',
    `is_default` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'is default',
    `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0:deleted,1:ok',
    `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'create time',
    `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'update time',
    PRIMARY KEY (`id`) USING BTREE,
    KEY `idx_uidname` (`userid`,`name`) USING BTREE,
    KEY `idx_u` (`userid`,`user_name_id`,`app`,`env_id`,`type`)
    ) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COMMENT='tempalte table';

CREATE TABLE IF NOT EXISTS ni_nvs.`livetran_image` (
    `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id',
    `userid` int(11) NOT NULL DEFAULT '0' COMMENT 'uid',
    `user_name_id` int(11) NOT NULL DEFAULT '0' COMMENT 'user name ID',
    `image_id` varchar(100) NOT NULL COMMENT 'IMAGE ID',
    `image_name` varchar(255) NOT NULL DEFAULT '' COMMENT 'name',
    `image_name_md5` varchar(100) NOT NULL COMMENT 'file name MD5',
    `size` int(11) NOT NULL DEFAULT '0' COMMENT 'file size',
    `checksum` varchar(50) NOT NULL DEFAULT '' COMMENT 'checksum',
    `in_used` int(2) NOT NULL COMMENT '0 unused, 1 in used',
    `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0:deleted,1:ok',
    `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'create time',
    `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'update time',
    PRIMARY KEY (`id`) USING BTREE,
    KEY `idx_uidname` (`userid`) USING BTREE
    ) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COMMENT='overlay picture table';

CREATE TABLE IF NOT EXISTS ni_nvs.`livetran_system_load` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `region` varchar(20) NOT NULL DEFAULT '' COMMENT 'region information',
  `cpu_load` float(10,2) NOT NULL,
  `vpu_encode` float(10,2) NOT NULL,
  `vpu_decode` float(10,2) NOT NULL,
  `memory` float(10,2) NOT NULL,
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'create time',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'update time',
  `deleted` int(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

/* ni_user */
CREATE TABLE IF NOT EXISTS ni_user.`livetran_user` (
    `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id',
    `userid` int(11) NOT NULL DEFAULT '0' COMMENT 'userid',
    `permissions` tinyint(4)  NOT NULL DEFAULT '0' COMMENT '0 user, 1 admin',
    `email` varchar(100) NOT NULL DEFAULT '' COMMENT 'email',
    `password` varchar(50) NOT NULL DEFAULT '' COMMENT 'password',
    `first_name` varchar(50) NOT NULL DEFAULT '' COMMENT 'first name',
    `middle_name` varchar(50) NOT NULL DEFAULT '' COMMENT 'middle name',
    `last_name` varchar(50) NOT NULL DEFAULT '' COMMENT 'last name',
    `avatar_info` longtext  COMMENT 'avatar image Base64',
    `phone` varchar(20) NOT NULL DEFAULT '' COMMENT 'phone',
    `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT '0:deleted,1:ok,2:temporarily disabled',
    `last_login_time` int(11) NOT NULL DEFAULT '0' COMMENT 'last login time',
    `expiry_date` int(11) NULL NULL DEFAULT '0'  COMMENT 'expiry time',
    `create_time` datetime NOT NULL COMMENT 'create time',
    `update_time` datetime NOT NULL COMMENT 'update time',
    PRIMARY KEY (`id`),
    UNIQUE KEY `idx_uid` (`userid`,`status`) USING BTREE,
    KEY `idx_em` (`email`,`status`) USING BTREE
    ) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COMMENT='user information table';

CREATE TABLE IF NOT EXISTS ni_user.`livetran_user_name` (
    `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id',
    `userid` int(11) NOT NULL DEFAULT '0' COMMENT 'user id',
    `user_name` varchar(255) NOT NULL DEFAULT '' COMMENT 'user_name',
    `quota_tran` int(11) NOT NULL DEFAULT '100' COMMENT 'quota',
    `formal_trial` enum('formal','trial') NOT NULL DEFAULT 'trial' COMMENT 'formal or trial user',
    `ext_param` text NULL COMMENT 'extra parameters',
    `erase_flag` tinyint(4) NOT NULL DEFAULT '1' COMMENT 'erase flag 0:deleted,1:ok,2:temporarily deleted',
    `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'create time',
    `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'update time',
    PRIMARY KEY (`id`) USING BTREE,
    KEY `idx_uname` (`erase_flag`,`user_name`) USING BTREE,
    KEY `idx_uid` (`userid`) USING BTREE
    ) ENGINE=InnoDB AUTO_INCREMENT=104 DEFAULT CHARSET=utf8mb4 COMMENT='user transcode information table';

CREATE TABLE IF NOT EXISTS ni_user.`livetran_user_signing` (
    `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
    `userid` int(11) NOT NULL DEFAULT '0' COMMENT 'userid',
    `user_name_id` int(11) NOT NULL DEFAULT '0' COMMENT 'user name id',
    `environment_id` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'environment id',
    `signing_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'rsa signing id',
    `key_name` varchar(50) NOT NULL,
    `rsa_private_key_md5` varchar(255) NOT NULL DEFAULT '' COMMENT 'rsa private key md5',
    `rsa_public_key` text NOT NULL COMMENT 'rsa public key',
    `status` tinyint(8) NOT NULL DEFAULT '1' COMMENT '0:deleted,1:ok',
    `create_time` datetime NOT NULL COMMENT 'create time',
    `update_time` datetime NOT NULL COMMENT 'update time',
    PRIMARY KEY (`id`),
    KEY `idx_uid` (`userid`,`user_name_id`,`status`),
    KEY `idx_sid` (`signing_id`,`userid`,`status`) USING BTREE
    ) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COMMENT='user signing table';

CREATE TABLE IF NOT EXISTS ni_user.`livetran_user_token` (
    `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id',
    `userid` int(11) NOT NULL COMMENT 'userid',
    `user_name_id` int(11) NOT NULL DEFAULT '0' COMMENT 'user name id',
    `name` varchar(255) NOT NULL DEFAULT '' COMMENT 'name',
    `description` varchar(255) NOT NULL DEFAULT '' COMMENT 'description',
    `token_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'access token_id',
    `token_secret_md5` varchar(255) NOT NULL DEFAULT '' COMMENT 'secret',
    `environment_id` int(11) NOT NULL DEFAULT '0' COMMENT 'environment id',
    `permissions` varchar(2048) NOT NULL DEFAULT '' COMMENT 'permissions',
    `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT '0:deleted,1:ok',
    `expires_at` int(11) NOT NULL DEFAULT '0' COMMENT 'expiration time,0:never expire',
    `create_time` datetime NOT NULL COMMENT 'create time',
    `update_time` datetime NOT NULL COMMENT 'update time',
    PRIMARY KEY (`id`),
    KEY `idx_token` (`token_id`,`status`,`environment_id`) USING BTREE,
    KEY `idx_u` (`userid`,`status`,`user_name_id`) USING BTREE
    ) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS ni_notification.`livetran_notification` (
    `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
    `user_id` int(11) NOT NULL,
    `user_name_id` int(11) NOT NULL,
    `region` varchar(50) NOT NULL,
    `from` int(2) NOT NULL COMMENT 'notification from 1:lms,2:nvs,3:trans',
    `notify_type` int(2) NOT NULL COMMENT 'notification type 1:source,2:pull/push streams,3:log',
    `notify_type_name` varchar(50) NOT NULL,
    `sub_type` int(2) NOT NULL COMMENT 'sub type',
    `sub_type_name` varchar(50) NOT NULL,
    `notify_info` text NOT NULL COMMENT 'notification information',
    `error_code` int(10) NOT NULL COMMENT 'error code',
    `notify_time` bigint(20) NOT NULL COMMENT 'notification time',
    `ack` int(1) NOT NULL COMMENT '0:unacked,1:acked',
    `retry_times` int(2) NOT NULL COMMENT 'retry times',
    `status` int(2) NOT NULL COMMENT '0:normal,1:deleted,2:Exception',
    `create_time` datetime NOT NULL COMMENT 'create time',
    `update_time` datetime NOT NULL COMMENT 'update time',
    PRIMARY KEY (`id`),
    INDEX `idx_type`(`from`, `notify_type`, `sub_type`, `notify_info`(150)) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS ni_notification.`livetran_notification_v2` (
   `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
   `notify_id` varchar(32) NOT NULL,
   `user_id` int(11) NOT NULL,
   `user_name_id` int(11) NOT NULL,
   `region` varchar(50) NOT NULL,
   `from` varchar(50) NOT NULL,
   `name` varchar(50) NOT NULL,
   `type` varchar(20) NOT NULL COMMENT 'info error warning',
   `stream_id` varchar(100) DEFAULT NULL,
   `info` text NOT NULL COMMENT 'notification information',
   `error_code` int(10) NOT NULL COMMENT 'error code',
   `notify_time` bigint(20) NOT NULL COMMENT 'notification time',
   `ack` int(1) NOT NULL COMMENT '0:unacked,1:acked',
   `retry_times` int(2) NOT NULL COMMENT 'retry times',
   `status` int(2) NOT NULL COMMENT '0:normal,1:deleted,2:Exception',
   `create_time` datetime NOT NULL COMMENT 'create time',
   `update_time` datetime NOT NULL COMMENT 'update time',
   PRIMARY KEY (`id`),
   KEY `idx_user` (`user_id`, `status`, `stream_id`) USING BTREE,
   KEY `idx_uuid` (`notify_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS ni_notification.`livetran_domain` (
    `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
    `user_id` int(11) NOT NULL,
    `user_name_id` int(11) NOT NULL,
    `domain` varchar(2048) NOT NULL,
    `status` int(4) NOT NULL,
    `create_time` datetime NOT NULL,
    `update_time` datetime NOT NULL,
    PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS ni_lms.`livetran_stream_v3` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `stream_id` varchar(50) NOT NULL UNIQUE,
    `user_id` int(11) NOT NULL,
    `organization_id` int(11) NOT NULL,
    `stream_key` varchar(255) NOT NULL,
    `name` varchar(255) NOT NULL,
    `description` varchar(255) DEFAULT NULL,
    `cover_url` varchar(255) DEFAULT NULL,
    `input_settings` text NOT NULL,
    `playback_settings` text NOT NULL,
    `redundancy` tinyint(2) NOT NULL DEFAULT 0,
    `regions` varchar(512) DEFAULT NULL,
    `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '0:deleted,1:visible',
    `create_time` datetime NOT NULL,
    `update_time` datetime NOT NULL,
    PRIMARY KEY (`id`),
    KEY `idx_u` (`user_id`) USING BTREE,
    KEY `idx_sid` (`stream_id`,`status`),
    KEY `idx_skey` (`status`,`stream_key`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS ni_lms.`offline_tran` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `trans_id` varchar(50) NOT NULL UNIQUE,
    `user_id` int(11) NOT NULL,
    `organization_id` int(11) NOT NULL,
    `name` varchar(255) NOT NULL,
    `description` varchar(255) DEFAULT NULL,
    `status` varchar(16) COMMENT 'deleted,running,completed,failed,queued,unknown',
    `status_message` text NOT NULL,
    `progress` tinyint(3) NOT NULL DEFAULT '0' COMMENT 'transcoding progress in percentage (0-100)',
    `input_file` text NOT NULL,
    `output_file` text NOT NULL,
    `create_time` datetime NOT NULL,
    `update_time` datetime NOT NULL,
    `deleted` tinyint(2) NOT NULL DEFAULT '0' COMMENT '1:deleted,0:visible',
    PRIMARY KEY (`id`),
    KEY `idx_tid` (`trans_id`) USING BTREE,
    KEY `idx_u` (`user_id`) USING BTREE,
    KEY `idx_sid` (`trans_id`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS ni_lms.`livetran_stream_source_status_v3`  (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `region` varchar(20) NOT NULL,
    `stream_id` varchar(255) NOT NULL,
    `stream_key` varchar(255) NOT NULL,
    `info` text NOT NULL,
    `status` tinyint(4) NOT NULL DEFAULT 1 COMMENT '5:stopped,1:idle,2:active,3:disabled,4:disconnected',
    `update_time` datetime NULL DEFAULT NULL COMMENT 'update time',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_skid`(`stream_key`, `region`) USING BTREE
    ) ENGINE = InnoDB AUTO_INCREMENT = 113 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = 'live streams source state table v3' ROW_FORMAT = DYNAMIC;

CREATE TABLE IF NOT EXISTS ni_lms.`livetran_stream_output_status_v3`  (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `region` varchar(20) NOT NULL,
    `playback_id` varchar(255) NOT NULL,
    `stream_id` varchar(50) NOT NULL,
    `event_id` varchar(255) NOT NULL,
    `output_stream_key` varchar(255) NOT NULL,
    `info` text NOT NULL,
    `status` tinyint(4) NOT NULL DEFAULT 1 COMMENT '0:idle,1:active',
    `update_time` datetime NULL DEFAULT NULL COMMENT 'update time',
    `latest_alert_type` varchar(20) NULL DEFAULT NULL COMMENT 'info,error,warning',
    `latest_alert_name` varchar(255) NULL DEFAULT NULL,
    `latest_alert_message` text NULL DEFAULT NULL,
    `latest_alert_time` datetime NULL DEFAULT NULL,
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_pbid`(`playback_id`, `region`) USING BTREE,
    INDEX `idx_osk`(`output_stream_key`, `region`) USING BTREE,
    INDEX `idx_stream_id` (`stream_id`) USING BTREE
    ) ENGINE = InnoDB AUTO_INCREMENT = 113 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = 'live streams source state table v3' ROW_FORMAT = DYNAMIC;

CREATE TABLE IF NOT EXISTS ni_lms.`livetran_stream_playback_v3` (
    `playback_id` varchar(255) NOT NULL,
    `stream_id` varchar(255) NOT NULL,
    `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT '0:deleted,1:ok',
    `create_time` datetime NOT NULL,
    PRIMARY KEY (`playback_id`) USING BTREE
    ) ENGINE = InnoDB AUTO_INCREMENT = 113 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = 'live streams playback_id->stream_id table v3' ROW_FORMAT = DYNAMIC;

CREATE TABLE IF NOT EXISTS ni_nvs.`livetran_task_v2` (
    `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id',
    `user_id` int(11) NOT NULL DEFAULT '0' COMMENT 'user id',
    `organization_id` int(11) NOT NULL DEFAULT '0' COMMENT 'user name id',
    `task_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'task id',
    `region` varchar(20) NOT NULL DEFAULT '' COMMENT 'region information',
    `input_url` varchar(2048) NOT NULL DEFAULT '' COMMENT 'input url',
    `params_json` text NOT NULL COMMENT 'task parameters JSON',
    `ext_info_json` text NOT NULL COMMENT 'extra information JSON',
    `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'create time',
    `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'update time',
    PRIMARY KEY (`id`) USING BTREE,
    KEY `idx_tid` (`task_id`,`region`) USING BTREE
    ) ENGINE=InnoDB AUTO_INCREMENT=73 DEFAULT CHARSET=utf8mb4 COMMENT='NVS task v2';

CREATE TABLE IF NOT EXISTS ni_lms.`livetran_stream_recording_v3` (
    `recording_id` varchar(255) NOT NULL,
    `stream_id` varchar(255) NOT NULL,
    `playback_id` varchar(255) NOT NULL,
    `event_id` varchar(255) NOT NULL,
    `status` varchar(64) NOT NULL COMMENT 'started/stopped/completed',
    `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT '1:deleted,0:ok',
    `start_time` datetime NOT NULL,
    `end_time` datetime,
    `output_path` text NOT NULL,
    PRIMARY KEY (`recording_id`) USING BTREE,
    INDEX `idx`(`deleted`, `stream_id`) USING BTREE
    ) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = DYNAMIC;

CREATE TABLE IF NOT EXISTS ni_lms.`livetran_stream_event_v3`  (
    `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id',
    `stream_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'stream id',
    `event_id` varchar(50) NOT NULL DEFAULT '' COMMENT 'event id',
    `start_time` datetime NOT NULL COMMENT 'start time',
    `end_time` datetime NULL DEFAULT NULL COMMENT 'end time',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_sid`(`stream_id`) USING BTREE
    ) ENGINE = InnoDB AUTO_INCREMENT = 21 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

SET FOREIGN_KEY_CHECKS = 1;
