# constants.py
# store Whisper daemon constants
import os

FFMPEG_INBOX_PREFIX = 'af_ni_whisper_asr_{}_inbox'
FFMPEG_TIMEBASE = 16000
SERVER_INBOX = 'daemon_ni_whisper_asr_inbox'
WORKER_INBOX = 'worker_inbox'
WORKER_OUTBOX = 'worker_outbox'
FFMPEG_PID_CHECK_INTERVAL = 60  # Set the check interval in seconds
FFMPEG_PID_CHECK_URL = "http://127.0.0.1:8057"
AI_TOKEN_MODE = True 
WHISPER_AI_MODEL = "small.en"
HTTP_PORT = 9098
CHUNK_CUTOFF_PTS = 8000 # 0.5 sec
MODEL_WARMUP_FILE=f"{os.getcwd()}/video/waiModelWarmupAudio.pkl"
LOG_FILE_SIZE_LIMIT = 5 * 1024 * 1024 * 1024 # 5G
LOG_DIR_SIZE_CHECK_INTERVAL = 3600
NO_SPEECH_PROB_MAX = 0.7 
AVG_LOGPROB_MIN = -1.0
COMPRESSION_RATIO_MAX = 4.0
SUPPRESS_LOW = [
    "Thank you",
    "Thanks for",
    "ike and ",
    "Bye.",
    "Bye!",
    "Bye bye!",
    "lease sub",
    "The end.",
]
SUPPRESS_HIGH = [
    "ubscribe",
    "my channel",
    "the channel",
    "our channel",
    "ollow me on",
    "for watching",
    "hank you for watching",
    "for your viewing",
    "r viewing",
    "Amara",
    "next video",
    "full video",
    "ranslation by",
    "ranslated by",
    "ee you next week",
]

GARBAGE_LIST = [
        "a",
        "aa",
        "ah",
        "ahh",
        "ha",
        "haa",
        "hah",
        "haha",
        "hahaha",
        "mmm",
        "mm",
        "m",
        "h",
        "o",
        "mh",
        "mmh",
        "hm",
        "hmm",
        "huh",
        "oh",
    ]
