/* Create table statements for all services */

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

CREATE DATABASE IF NOT EXISTS `ni_lms`;
CREATE DATABASE IF NOT EXISTS `ni_nvs`;
CREATE DATABASE IF NOT EXISTS `ni_user`;
CREATE DATABASE IF NOT EXISTS `ni_notification`;

/* ni_lms */
CREATE TABLE IF NOT EXISTS ni_lms.`livetran_license` (
    `id` int(10) NOT NULL AUTO_INCREMENT,
    `license_info` longtext COMMENT 'license info',
    `running_condition` longtext,
    `create_time` datetime NOT NULL,
    `update_time` datetime NOT NULL,
    `deleted` int(2) unsigned NOT NULL COMMENT '0 in use, 1 deleted',
    PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS ni_lms.`livetran_origin` (
    `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
    `playback_host` varchar(512) NOT NULL,
    `config_json` varchar(1024) NOT NULL,
    `load` int(11) NOT NULL,
    `status` tinyint(4) NOT NULL,
    `region` varchar(20) NOT NULL,
    PRIMARY KEY (`id`),
    UNIQUE (`playback_host`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS ni_lms.`livetran_stream_origin` (
    `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
    `playback_host` varchar(512) NOT NULL,
    `output_stream_key` varchar(255) NOT NULL,
    `num_output_streams` int(11) NOT NULL,
    `region` varchar(20) NOT NULL,
    `origin_config_json` varchar(1024) NOT NULL,
    PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


CREATE TABLE IF NOT EXISTS ni_nvs.`livetran_system_load` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `region` varchar(20) NOT NULL DEFAULT '' COMMENT 'region information',
  `cpu_load` float(10,2) NOT NULL,
  `vpu_encode` float(10,2) NOT NULL,
  `vpu_decode` float(10,2) NOT NULL,
  `memory` float(10,2) NOT NULL,
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'create time',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'update time',
  `deleted` int(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

/* ni_user */
CREATE TABLE IF NOT EXISTS ni_user.`livetran_user` (
    `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id',
    `userid` int(11) NOT NULL DEFAULT '0' COMMENT 'userid',
    `permissions` tinyint(4)  NOT NULL DEFAULT '0' COMMENT '0 user, 1 admin',
    `email` varchar(100) NOT NULL DEFAULT '' COMMENT 'email',
    `password` varchar(50) NOT NULL DEFAULT '' COMMENT 'password',
    `first_name` varchar(50) NOT NULL DEFAULT '' COMMENT 'first name',
    `middle_name` varchar(50) NOT NULL DEFAULT '' COMMENT 'middle name',
    `last_name` varchar(50) NOT NULL DEFAULT '' COMMENT 'last name',
    `avatar_info` longtext  COMMENT 'avatar image Base64',
    `phone` varchar(20) NOT NULL DEFAULT '' COMMENT 'phone',
    `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT '0:deleted,1:ok,2:temporarily disabled',
    `last_login_time` int(11) NOT NULL DEFAULT '0' COMMENT 'last login time',
    `expiry_date` int(11) NULL NULL DEFAULT '0'  COMMENT 'expiry time',
    `create_time` datetime NOT NULL COMMENT 'create time',
    `update_time` datetime NOT NULL COMMENT 'update time',
    PRIMARY KEY (`id`),
    UNIQUE KEY `idx_uid` (`userid`,`status`) USING BTREE,
    KEY `idx_em` (`email`,`status`) USING BTREE
    ) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='user information table';

CREATE TABLE IF NOT EXISTS ni_user.`livetran_user_name` (
    `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id',
    `userid` int(11) NOT NULL DEFAULT '0' COMMENT 'user id',
    `user_name` varchar(255) NOT NULL DEFAULT '' COMMENT 'user_name',
    `quota_tran` int(11) NOT NULL DEFAULT '100' COMMENT 'quota',
    `formal_trial` enum('formal','trial') NOT NULL DEFAULT 'trial' COMMENT 'formal or trial user',
    `ext_param` text NULL COMMENT 'extra parameters',
    `erase_flag` tinyint(4) NOT NULL DEFAULT '1' COMMENT 'erase flag 0:deleted,1:ok,2:temporarily deleted',
    `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'create time',
    `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'update time',
    PRIMARY KEY (`id`) USING BTREE,
    KEY `idx_uname` (`erase_flag`,`user_name`) USING BTREE,
    KEY `idx_uid` (`userid`) USING BTREE
    ) ENGINE=InnoDB AUTO_INCREMENT=104 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='user transcode information table';

CREATE TABLE IF NOT EXISTS ni_user.`livetran_user_signing` (
    `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
    `userid` int(11) NOT NULL DEFAULT '0' COMMENT 'userid',
    `user_name_id` int(11) NOT NULL DEFAULT '0' COMMENT 'user name id',
    `environment_id` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'environment id',
    `signing_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'rsa signing id',
    `key_name` varchar(50) NOT NULL,
    `rsa_private_key_md5` varchar(255) NOT NULL DEFAULT '' COMMENT 'rsa private key md5',
    `rsa_public_key` text NOT NULL COMMENT 'rsa public key',
    `status` tinyint(8) NOT NULL DEFAULT '1' COMMENT '0:deleted,1:ok',
    `create_time` datetime NOT NULL COMMENT 'create time',
    `update_time` datetime NOT NULL COMMENT 'update time',
    PRIMARY KEY (`id`),
    KEY `idx_uid` (`userid`,`user_name_id`,`status`),
    KEY `idx_sid` (`signing_id`,`userid`,`status`) USING BTREE
    ) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='user signing table';

CREATE TABLE IF NOT EXISTS ni_user.`livetran_user_token` (
    `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id',
    `userid` int(11) NOT NULL COMMENT 'userid',
    `user_name_id` int(11) NOT NULL DEFAULT '0' COMMENT 'user name id',
    `name` varchar(255) NOT NULL DEFAULT '' COMMENT 'name',
    `description` varchar(255) NOT NULL DEFAULT '' COMMENT 'description',
    `token_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'access token_id',
    `token_secret_md5` varchar(255) NOT NULL DEFAULT '' COMMENT 'secret',
    `environment_id` int(11) NOT NULL DEFAULT '0' COMMENT 'environment id',
    `permissions` varchar(2048) NOT NULL DEFAULT '' COMMENT 'permissions',
    `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT '0:deleted,1:ok',
    `expires_at` int(11) NOT NULL DEFAULT '0' COMMENT 'expiration time,0:never expire',
    `create_time` datetime NOT NULL COMMENT 'create time',
    `update_time` datetime NOT NULL COMMENT 'update time',
    PRIMARY KEY (`id`),
    KEY `idx_token` (`token_id`,`status`,`environment_id`) USING BTREE,
    KEY `idx_u` (`userid`,`status`,`user_name_id`) USING BTREE
    ) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS ni_notification.`livetran_notification_v2` (
   `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
   `notify_id` varchar(32) NOT NULL,
   `user_id` int(11) NOT NULL,
   `user_name_id` int(11) NOT NULL,
   `region` varchar(50) NOT NULL,
   `from` varchar(50) NOT NULL,
   `name` varchar(50) NOT NULL,
   `type` varchar(20) NOT NULL COMMENT 'info error warning',
   `stream_id` varchar(100) DEFAULT NULL,
   `info` text NOT NULL COMMENT 'notification information',
   `error_code` int(10) NOT NULL COMMENT 'error code',
   `notify_time` bigint(20) NOT NULL COMMENT 'notification time',
   `ack` int(1) NOT NULL COMMENT '0:unacked,1:acked',
   `retry_times` int(2) NOT NULL COMMENT 'retry times',
   `status` int(2) NOT NULL COMMENT '0:normal,1:deleted,2:Exception',
   `create_time` datetime NOT NULL COMMENT 'create time',
   `update_time` datetime NOT NULL COMMENT 'update time',
   PRIMARY KEY (`id`),
   KEY `idx_user` (`user_id`, `status`, `stream_id`) USING BTREE,
   KEY `idx_uuid` (`notify_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS ni_notification.`livetran_domain` (
    `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
    `user_id` int(11) NOT NULL,
    `user_name_id` int(11) NOT NULL,
    `domain` varchar(2048) NOT NULL,
    `status` int(4) NOT NULL,
    `create_time` datetime NOT NULL,
    `update_time` datetime NOT NULL,
    PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS ni_lms.`livetran_stream_v3` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `stream_id` varchar(50) NOT NULL UNIQUE,
    `user_id` int(11) NOT NULL,
    `organization_id` int(11) NOT NULL,
    `stream_key` varchar(255) NOT NULL,
    `name` varchar(255) NOT NULL,
    `description` varchar(255) DEFAULT NULL,
    `cover_url` varchar(255) DEFAULT NULL,
    `input_settings` text NOT NULL,
    `playback_settings` text NOT NULL,
    `redundancy` tinyint(2) NOT NULL DEFAULT 0,
    `regions` varchar(512) DEFAULT NULL,
    `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '0:deleted,1:visible',
    `create_time` datetime NOT NULL,
    `update_time` datetime NOT NULL,
    `slate_state_json` text NULL,
    PRIMARY KEY (`id`),
    KEY `idx_u` (`user_id`) USING BTREE,
    KEY `idx_sid` (`stream_id`,`status`),
    KEY `idx_skey` (`status`,`stream_key`) USING BTREE,
    UNIQUE KEY `unique_stream_key_idx` (`stream_key`, (CASE WHEN `status` != 0 THEN 1 ELSE NULL END)) using BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS ni_lms.`offline_tran` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `trans_id` varchar(50) NOT NULL UNIQUE,
    `user_id` int(11) NOT NULL,
    `organization_id` int(11) NOT NULL,
    `name` varchar(255) NOT NULL,
    `description` varchar(255) DEFAULT NULL,
    `status` varchar(50) COMMENT 'deleted,running,completed,failed,queued,unknown,transcoding completed: post-processing failed,transcoding completed: post-processing',
    `status_message` text NOT NULL,
    `progress` tinyint(3) NOT NULL DEFAULT '0' COMMENT 'transcoding progress in percentage (0-100)',
    `post_processing_status` tinyint(2) NOT NULL DEFAULT '-1' COMMENT '-1:none required,0:all done,1:task required',
    `input_file` text NOT NULL,
    `input_subs_files` text NOT NULL,
    `output_file` text NOT NULL,
    `create_time` datetime NOT NULL,
    `update_time` datetime NOT NULL,
    `transcoding_start_time` datetime NULL DEFAULT NULL,
    `transcoding_end_time` datetime NULL DEFAULT NULL,
    `deleted` tinyint(2) NOT NULL DEFAULT '0' COMMENT '1:deleted,0:visible',
    PRIMARY KEY (`id`),
    KEY `idx_tid` (`trans_id`) USING BTREE,
    KEY `idx_u` (`user_id`) USING BTREE,
    KEY `idx_sid` (`trans_id`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS ni_lms.`livetran_stream_source_status_v3`  (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `region` varchar(20) NOT NULL,
    `stream_id` varchar(255) NOT NULL,
    `stream_key` varchar(255) NOT NULL,
    `info` text NOT NULL,
    `status` tinyint(4) NOT NULL DEFAULT 1 COMMENT '5:stopped,1:idle,2:active,3:disabled,4:disconnected',
    `update_time` datetime NULL DEFAULT NULL COMMENT 'update time',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_skid`(`stream_key`, `region`) USING BTREE
    ) ENGINE = InnoDB AUTO_INCREMENT = 113 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = 'live streams source state table v3' ROW_FORMAT = DYNAMIC;

CREATE TABLE IF NOT EXISTS ni_lms.`livetran_stream_output_status_v3`  (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `region` varchar(20) NOT NULL,
    `playback_id` varchar(255) NOT NULL,
    `stream_id` varchar(50) NOT NULL,
    `event_id` varchar(255) NOT NULL,
    `output_stream_key` varchar(255) NOT NULL,
    `info` text NOT NULL,
    `status` tinyint(4) NOT NULL DEFAULT 1 COMMENT '0:idle,1:active',
    `update_time` datetime NULL DEFAULT NULL COMMENT 'update time',
    `latest_alert_type` varchar(20) NULL DEFAULT NULL COMMENT 'info,error,warning',
    `latest_alert_name` varchar(255) NULL DEFAULT NULL,
    `latest_alert_message` text NULL DEFAULT NULL,
    `latest_alert_time` datetime NULL DEFAULT NULL,
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_pbid`(`playback_id`, `region`) USING BTREE,
    INDEX `idx_osk`(`output_stream_key`, `region`) USING BTREE,
    INDEX `idx_stream_id` (`stream_id`) USING BTREE
    ) ENGINE = InnoDB AUTO_INCREMENT = 113 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = 'live streams source state table v3' ROW_FORMAT = DYNAMIC;

CREATE TABLE IF NOT EXISTS ni_lms.`livetran_stream_playback_v3` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `playback_id` varchar(255) NOT NULL,
    `stream_id` varchar(255) NOT NULL,
    `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT '0:deleted,1:ok',
    `create_time` datetime NOT NULL,
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE KEY `idx_playback_id` (`playback_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='live streams playback_id->stream_id table v3' ROW_FORMAT=DYNAMIC;

CREATE TABLE IF NOT EXISTS ni_nvs.`livetran_task_v2` (
    `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id',
    `user_id` int(11) NOT NULL DEFAULT '0' COMMENT 'user id',
    `organization_id` int(11) NOT NULL DEFAULT '0' COMMENT 'user name id',
    `task_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'task id',
    `region` varchar(20) NOT NULL DEFAULT '' COMMENT 'region information',
    `input_url` varchar(2048) NOT NULL DEFAULT '' COMMENT 'input url',
    `params_json` text NOT NULL COMMENT 'task parameters JSON',
    `ext_info_json` text NOT NULL COMMENT 'extra information JSON',
    `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'create time',
    `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'update time',
    PRIMARY KEY (`id`) USING BTREE,
    KEY `idx_tid` (`task_id`,`region`) USING BTREE
    ) ENGINE=InnoDB AUTO_INCREMENT=73 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='NVS task v2';

CREATE TABLE IF NOT EXISTS ni_lms.`livetran_stream_recording_v3` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `recording_id` varchar(255) NOT NULL,
    `stream_id` varchar(255) NOT NULL,
    `playback_id` varchar(255) NOT NULL,
    `event_id` varchar(255) NOT NULL,
    `status` varchar(64) NOT NULL COMMENT 'started/stopped/completed',
    `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT '1:deleted,0:ok',
    `start_time` datetime NOT NULL,
    `end_time` datetime,
    `output_path` text NOT NULL,
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE KEY `idx_recording_id` (`recording_id`) USING BTREE,
    INDEX `idx`(`deleted`, `stream_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;

CREATE TABLE IF NOT EXISTS ni_lms.`livetran_stream_event_v3`  (
    `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id',
    `stream_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'stream id',
    `event_id` varchar(50) NOT NULL DEFAULT '' COMMENT 'event id',
    `start_time` datetime NOT NULL COMMENT 'start time',
    `end_time` datetime NULL DEFAULT NULL COMMENT 'end time',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_sid`(`stream_id`) USING BTREE
    ) ENGINE = InnoDB AUTO_INCREMENT = 21 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

CREATE TABLE IF NOT EXISTS ni_lms.`livetran_capture_card` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `device_id` varchar(1024) NOT NULL,
    `port` varchar(1024) NOT NULL,
    `protocol` varchar(255) NOT NULL,
    `stream_id` varchar(255) DEFAULT NULL,
    `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'create time',
    `unique_hash` char(32) GENERATED ALWAYS AS (MD5(CONCAT(`device_id`, `protocol`))) VIRTUAL,
    UNIQUE KEY `unique_card` (`unique_hash`) USING BTREE,
    PRIMARY KEY (`id`) USING BTREE
    ) ENGINE = InnoDB AUTO_INCREMENT = 21 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

CREATE TABLE IF NOT EXISTS ni_lms.`livetran_networking_settings` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `region` varchar(20) NOT NULL,
    `settings_json` text NOT NULL,
    `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'update time',
    UNIQUE KEY (`region`),
    PRIMARY KEY (`id`) USING BTREE
    ) ENGINE = InnoDB AUTO_INCREMENT = 21 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

CREATE TABLE IF NOT EXISTS ni_lms.`livetran_template` (
    `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id',
    `user_id` int(11) NOT NULL COMMENT 'user id',
    `organization_id` int(11) NOT NULL COMMENT 'organization id',
    `name` varchar(255) NOT NULL COMMENT 'template name',
    `description` varchar(255) DEFAULT NULL COMMENT 'description',
    `format` varchar(2048) NOT NULL COMMENT 'basic format parameters',
    `output` text NOT NULL COMMENT 'output stream information',
    `advanced_params` varchar(4096) NOT NULL COMMENT 'advanced parameters',
    `status` tinyint(2) NOT NULL DEFAULT 0 COMMENT '0:deleted,1:ok',
    `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'create time',
    `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'update time',
    PRIMARY KEY (`id`),
    KEY `idx_uid_org_name` (`user_id`, `organization_id`, `name`),
    KEY `idx_uid_org_name_status` (`user_id`, `organization_id`, `name`, `status`),
    KEY `idx_uid_org` (`user_id`, `organization_id`),
    KEY `idx_uid_org_status` (`user_id`, `organization_id`, `status`),
    KEY `idx_status` (`status`)
    ) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='template table';

CREATE TABLE IF NOT EXISTS ni_lms.`livetran_image` (
    `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id',
    `user_id` int(11) NOT NULL COMMENT 'user id',
    `organization_id` int(11) NOT NULL COMMENT 'organization id',
    `image_id` varchar(100) NOT NULL COMMENT 'image id',
    `image_name` varchar(255) NOT NULL COMMENT 'image name',
    `checksum` varchar(50) NOT NULL COMMENT 'checksum',
    `size` int(11) NOT NULL COMMENT 'file size',
    `in_used` tinyint(2) NOT NULL COMMENT '0 unused, 1 in used',
    `status` tinyint(4) NOT NULL DEFAULT 0 COMMENT '0:deleted,1:ok',
    `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'create time',
    `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'update time',
    PRIMARY KEY (`id`),
    KEY `idx_uid_org_name` (`user_id`, `organization_id`, `image_name`),
    KEY `idx_uid_org_name_status` (`user_id`, `organization_id`, `image_name`, `status`),
    KEY `idx_uid_org_status` (`user_id`, `organization_id`, `status`),
    KEY `idx_status` (`status`)
    ) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='overlay picture table';

CREATE TABLE IF NOT EXISTS ni_lms.livetran_secrets (
    `id`          int NOT NULL PRIMARY KEY AUTO_INCREMENT,
    `user_id`     int NOT NULL,
    `name`        varchar(255) NOT NULL,
    `secret_id`   text NOT NULL,
    `secret_key`  text NOT NULL,
    `in_use`     int NOT NULL,
    `create_time` DATETIME NOT NULL,
    UNIQUE KEY `unique_name` (`name`, `user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ENCRYPTION='Y';

SET FOREIGN_KEY_CHECKS = 1;
