/*
 * Copyright 2015 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef NI_OMX_ENCODER_H_
#define NI_OMX_ENCODER_H_

#include <map>

#include <media/stagefright/foundation/ABase.h>
#include <media/stagefright/omx/SoftVideoEncoderOMXComponent.h>

#include "ni_device_api.h"
#include "vidc_vendor_extensions.h"

namespace android {

#define MAX_CONVERSION_BUFFERS   4

/** Used to remove warnings about unused parameters */
#define UNUSED(x) ((void)(x))

typedef struct NiOMXEncCtx{
  int started;
  bool m_sps_pps_arrived;
  bool m_first_pkt_arrived;
  uint8_t *m_spsPpsHdr;
  int m_spsPpsHdrLen;
  uint64_t m_total_frames_received;
  int dev_enc_idx;
  ni_session_context_t api_ctx;
  ni_xcoder_params_t   api_param;
  ni_session_data_io_t api_pkt;
  ni_session_data_io_t api_fme;
} NiOMXEncCtx;

struct NiQuadraOMXEncoder : public SoftVideoEncoderOMXComponent {
    NiQuadraOMXEncoder(const char *name,
        const char *componentRole,
        OMX_VIDEO_CODINGTYPE codingType,
        const char *mimeType,
        const CodecProfileLevel *profileLevels,
        size_t numProfileLevels,
        const OMX_CALLBACKTYPE *callbacks,
        OMX_PTR appData,
        OMX_COMPONENTTYPE **component);

protected:
    ni_codec_format_t m_codec_type;

    virtual ~NiQuadraOMXEncoder();

    virtual OMX_ERRORTYPE internalGetParameter(
            OMX_INDEXTYPE index, OMX_PTR params);

    virtual OMX_ERRORTYPE internalSetParameter(
            OMX_INDEXTYPE index, const OMX_PTR params);

    virtual void onQueueFilled(OMX_U32 portIndex);

    virtual void onReset();

private:
    //Number of input and output buffers
    enum {
        kNumBuffers = 8
    };

    struct timeval mTimeStart;  // Time at the start of encode()
    struct timeval mTimeEnd;    // Time at the end of encode()

    OMX_VIDEO_PARAM_AVCTYPE m_sParamAVC;
    OMX_VIDEO_PARAM_HEVCTYPE m_sParamHEVC;

    bool m_input_eos;
    bool m_output_eos;
    bool m_send_eos;
    bool m_is_closed;
    bool m_is_initialized;
    bool m_signalled_error;

    NiOMXEncCtx *m_ctx;

    int m_cb_index;
    uint8_t *m_convert_buffers[MAX_CONVERSION_BUFFERS];
    bool m_convert_buffers_free[MAX_CONVERSION_BUFFERS];

    enum {
        //initialization parameter
        QUADRA_IndexConfigVideoBitrate = OMX_IndexVendorStartUnused + 100, //0x7F000000 + 100
        QUADRA_IndexConfigVideoProfile,
        QUADRA_IndexConfigVideoLevel,
        QUADRA_IndexConfigVideoGopPresetIdx,
        QUADRA_IndexConfigVideoLowDelay,
        QUADRA_IndexConfigVideoUseLowDelayPocType,
        QUADRA_IndexConfigVideoRcEnable,
        QUADRA_IndexConfigVideoCuLevelRCEnable,
        QUADRA_IndexConfigVideoIntraPeriod,
        QUADRA_IndexConfigVideoIntraQP,
        QUADRA_IndexConfigVideoSliceMode,
        QUADRA_IndexConfigVideoSliceArg,
        QUADRA_IndexConfigVideoIntraRefreshMode,
        QUADRA_IndexConfigVideoIntraRefreshArg,
        QUADRA_IndexConfigVideoIntraMbRefreshMode,
        QUADRA_IndexConfigVideoIntraMbRefreshArg,
        QUADRA_IndexConfigVideoMbLevelRcEnable,
        QUADRA_IndexConfigVideoCrf,
        QUADRA_IndexConfigVideoCrfFloat,
        QUADRA_IndexConfigVideoRdoLevel,
        QUADRA_IndexConfigVideoEnableRdoQuant,
        QUADRA_IndexConfigVideoLookAheadDepth,
        QUADRA_IndexConfigVideoVbvBufferSize,
        QUADRA_IndexConfigVideoVbvMaxRate,
        QUADRA_IndexConfigVideoMulticoreJointMode,
        QUADRA_IndexConfigVideoQlevel,
        QUADRA_IndexConfigVideoChromaQpOffset,
        QUADRA_IndexConfigVideoTolCtbRcInter,
        QUADRA_IndexConfigVideoTolCtbRcIntra,
        QUADRA_IndexConfigVideoEnable2PassGop,
        QUADRA_IndexConfigVideoZeroCopyMode,

        //reconfigure parameter
        QUADRA_IndexConfigVideoReconfigBitrate,
        QUADRA_IndexConfigVideoReconfigIntraPeriod,
        QUADRA_IndexConfigVideoReconfigForceIDRFrame,
        QUADRA_IndexConfigVideoReconfigLTR,
        QUADRA_IndexConfigVideoReconfigLTRInterval,
        QUADRA_IndexConfigVideoReconfigFrameRefInvalid,
        QUADRA_IndexConfigVideoReconfigMaxFrameSize,
        QUADRA_IndexConfigVideoReconfigMinMaxQp,
        QUADRA_IndexConfigVideoReconfigCRF,
        QUADRA_IndexConfigVideoReconfigCRF2,
        QUADRA_IndexConfigVideoReconfigVbv,
        QUADRA_IndexConfigVideoReconfigMaxFrameSizeRatio,
    };

    VendorExtensionStore m_vendor_extension_store;
    std::map<std::string, std::string> m_xcoder_params;

    int32_t m_intra_period;
    ni_long_term_ref_t m_ltr;
    int32_t m_ltr_interval;
    int32_t m_ltr_frame_ref_invalid;
    int32_t m_max_frame_size;
    ni_rc_min_max_qp m_min_max_qp;
    int32_t m_crf;
    float m_crf2;
    int32_t m_vbvMaxRate;
    int32_t m_vbvBufferSize;
    int32_t m_max_frame_size_ratio;

    void init_vendor_extensions(
        VendorExtensionStore &store);

    OMX_ERRORTYPE get_vendor_extension_config(
        OMX_CONFIG_ANDROID_VENDOR_EXTENSIONTYPE *ext);

    OMX_ERRORTYPE set_vendor_extension_config(
        OMX_CONFIG_ANDROID_VENDOR_EXTENSIONTYPE *ext);

    OMX_ERRORTYPE internalSetConfig(
        OMX_INDEXTYPE index, const OMX_PTR _params, bool *frameConfig);

    OMX_ERRORTYPE getConfig(
        OMX_INDEXTYPE index, const OMX_PTR _params);

    bool extractGraphicBuffer(
        OMX_BUFFERHEADERTYPE *inHeader,
        uint8_t *conversionBuffer);

    OMX_ERRORTYPE xcoder_reconfig_bitrate();

    OMX_ERRORTYPE xcoder_reconfig_intraprd();

    OMX_ERRORTYPE xcoder_force_idr_frame();

    OMX_ERRORTYPE xcoder_reconfig_ltr();

    OMX_ERRORTYPE xcoder_reconfig_ltr_interval();

    OMX_ERRORTYPE xcoder_set_frame_ref_invalid();

    OMX_ERRORTYPE xcoder_reconfig_max_frame_size();

    OMX_ERRORTYPE xcoder_reconfig_min_max_qp();

    OMX_ERRORTYPE xcoder_reconfig_crf();

    OMX_ERRORTYPE xcoder_reconfig_crf2();

    OMX_ERRORTYPE xcoder_reconfig_vbv();

    OMX_ERRORTYPE xcoder_reconfig_max_frame_size_ratio();

    int xcoder_encode_init();

    int xcoder_setup_encoder();

    int xcoder_send_frame(
            OMX_BUFFERHEADERTYPE *inHeader, bool *send_frame);

    int xcoder_receive_packet(
            OMX_BUFFERHEADERTYPE *outHeader, bool *get_pkt);
            
    int xcoder_send_receive(
        OMX_BUFFERHEADERTYPE *inHeader, bool *send_frame,
        OMX_BUFFERHEADERTYPE *outHeader, bool *get_pkt);

    int xcoder_encode_close();

    int xcoder_encode_reset();
//
    DISALLOW_EVIL_CONSTRUCTORS (NiQuadraOMXEncoder);
};

} // namespace android

#endif  // NI_OMX_ENCODER_H_
