/*
 * Copyright 2015 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "NiQuadraOMXH265Decoder.h"
#include "SoftHEVC.h"
#include <media/stagefright/MediaDefs.h>

namespace android {

#define componentName                   "video_decoder.hevc"
#define codingType                      OMX_VIDEO_CodingHEVC
#define CODEC_MIME_TYPE                 MEDIA_MIMETYPE_VIDEO_HEVC

static const CodecProfileLevel profile_levels[] = {
  { OMX_VIDEO_HEVCProfileMain,      OMX_VIDEO_HEVCHighTierLevel51 },

  { OMX_VIDEO_HEVCProfileMain10,    OMX_VIDEO_HEVCHighTierLevel51 },

  { OMX_VIDEO_HEVCProfileMainStill, OMX_VIDEO_HEVCHighTierLevel51 },
};

NiQuadraOMXH265Decoder::NiQuadraOMXH265Decoder(
      const char *name,
      const OMX_CALLBACKTYPE *callbacks,
      OMX_PTR appData,
      OMX_COMPONENTTYPE **component)
      : NiQuadraOMXDecoder(name, componentName, codingType, CODEC_MIME_TYPE,
          profile_levels, ARRAY_SIZE(profile_levels), callbacks, appData, component) {
    m_codec_type = CODEC_FORMAT_H265;
  }

} // namespace android

android::SoftOMXComponent *createSoftOMXComponent(
        const char *name, const OMX_CALLBACKTYPE *callbacks, OMX_PTR appData,
        OMX_COMPONENTTYPE **component) {
  if (android::NiQuadraOMXH265Decoder::check_ni_decoder_is_available()) {
    ALOGI("Create one NiQuadraOMXH265Decoder component instance");
    return new android::NiQuadraOMXH265Decoder(name, callbacks, appData, component);
  } else {
    ALOGI("Create one SoftHEVC component instance");
    return new android::SoftHEVC(name, callbacks, appData, component);
  }
}
