/*******************************************************************************
 *
 * Copyright (C) 2023 NETINT Technologies
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 ******************************************************************************/

/*!*****************************************************************************
 *  \file   gstniquadra.c
 *
 *  \brief  Plugin init of NetInt Quadra element
 ******************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include <gst/gst.h>
#include "gstniquadrah265dec.h"
#include "gstniquadravp9dec.h"
#include "gstniquadrah264dec.h"
#include "gstniquadrajpegdec.h"
#include "niquadra.h"
#include "gstniquadrah264enc.h"
#include "gstniquadrah265enc.h"
#include "gstniquadrajpegenc.h"
#include "gstniquadraav1enc.h"

GST_DEBUG_CATEGORY (gst_niquadra_debug);
GST_DEBUG_CATEGORY (gst_niquadradec_debug);
GST_DEBUG_CATEGORY (gst_niquadraenc_debug);
GST_DEBUG_CATEGORY (gst_niquadrah264dec_debug);
GST_DEBUG_CATEGORY (gst_niquadrah265dec_debug);
GST_DEBUG_CATEGORY (gst_niquadravp9dec_debug);
GST_DEBUG_CATEGORY (gst_niquadrajpegdec_debug);
GST_DEBUG_CATEGORY (gst_niquadrah264enc_debug);
GST_DEBUG_CATEGORY (gst_niquadrah265enc_debug);
GST_DEBUG_CATEGORY (gst_niquadrajpegenc_debug);
GST_DEBUG_CATEGORY (gst_niquadraav1enc_debug);

extern gboolean gst_niquadrahwuploader_register (GstPlugin * plugin);

static gboolean
plugin_init (GstPlugin * plugin)
{
  gboolean ret = TRUE;

  GST_DEBUG_CATEGORY_INIT (gst_niquadra_debug, "niquadra", 0, "niquadra");
  GST_DEBUG_CATEGORY_INIT (gst_niquadradec_debug, "niquadradec", 0,
      "niquadradec");
  GST_DEBUG_CATEGORY_INIT (gst_niquadraenc_debug, "niquadraenc", 0,
      "niquadraenc");
  GST_DEBUG_CATEGORY_INIT (gst_niquadrah264dec_debug, "niquadrah264dec", 0,
      "niquadradech264");
  GST_DEBUG_CATEGORY_INIT (gst_niquadrah265dec_debug, "niquadrah265dec", 0,
      "niquadradech265");
  GST_DEBUG_CATEGORY_INIT (gst_niquadravp9dec_debug, "niquadravp9dec", 0,
      "niquadradecvp9");
  GST_DEBUG_CATEGORY_INIT (gst_niquadrajpegdec_debug, "niquadrajpegdec", 0,
      "niquadradecjpeg");

  GST_DEBUG_CATEGORY_INIT (gst_niquadrah264enc_debug, "niquadrah264enc", 0,
      "niquadrah264enc");
  GST_DEBUG_CATEGORY_INIT (gst_niquadrah265enc_debug, "niquadrah265enc", 0,
      "niquadrah265enc");
  GST_DEBUG_CATEGORY_INIT (gst_niquadrajpegenc_debug, "niquadrajpegenc", 0,
      "niquadrajpegenc");
  GST_DEBUG_CATEGORY_INIT (gst_niquadraav1enc_debug, "niquadraav1enc", 0,
      "niquadraav1enc");

  ret &= gst_element_register (plugin, "niquadrah264dec", GST_RANK_NONE,
      GST_TYPE_NIQUADRAH264DEC);
  ret &= gst_element_register (plugin, "niquadrah265dec", GST_RANK_NONE,
      GST_TYPE_NIQUADRAH265DEC);
  ret &= gst_element_register (plugin, "niquadravp9dec", GST_RANK_NONE,
      GST_TYPE_NIQUADRAVP9DEC);
  ret &= gst_element_register (plugin, "niquadrajpegdec", GST_RANK_NONE,
      GST_TYPE_NIQUADRAJPEGDEC);

  ret &= gst_element_register (plugin, "niquadrah264enc", GST_RANK_NONE,
      GST_TYPE_NIQUADRAH264ENC);
  ret &= gst_element_register (plugin, "niquadrah265enc", GST_RANK_NONE,
      GST_TYPE_NIQUADRAH265ENC);
  ret &= gst_element_register (plugin, "niquadrajpegenc", GST_RANK_NONE,
      GST_TYPE_NIQUADRAJPEGENC);
  ret &= gst_element_register (plugin, "niquadraav1enc", GST_RANK_NONE,
      GST_TYPE_NIQUADRAAV1ENC);

  ret &= gst_niquadrahwdownload_register (plugin);
  ret &= gst_niquadrahwupload_register (plugin);
  ret &= gst_niquadrascale_register (plugin);
  ret &= gst_niquadradrawbox_register (plugin);
  ret &= gst_niquadrarotate_register (plugin);
  ret &= gst_niquadracrop_register (plugin);
  ret &= gst_niquadrapad_register (plugin);
  ret &= gst_niquadrastack_register (plugin);
  ret &= gst_niquadraoverlay_register (plugin);
  ret &= gst_niquadrabgr_register (plugin);
  ret &= gst_niquadraroi_register (plugin);
  ret &= gst_niquadrabg_register (plugin);
  ret &= gst_niquadradelogo_register (plugin);
  ret &= gst_niquadraflip_register (plugin);
  ret &= gst_niquadramerge_register (plugin);
  ret &= gst_niquadraaipre_register (plugin);
  ret &= gst_niquadrainterleave_register (plugin);
  ret &= gst_niquadrasplit_register (plugin);

  return ret;
}

GST_PLUGIN_DEFINE (GST_VERSION_MAJOR,
    GST_VERSION_MINOR,
    niquadra,
    "Xcoder SDK based elements",
    plugin_init, VERSION, "LGPL", GST_PACKAGE_NAME, GST_PACKAGE_ORIGIN)
