/*******************************************************************************
 *
 * Copyright (C) 2023 NETINT Technologies
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 ******************************************************************************/

/*!*****************************************************************************
 *  \file   gstniquadrah264enc.c
 *
 *  \brief  Implement of NetInt Quadra h264 encoder.
 ******************************************************************************/

#include "gstniquadrah264enc.h"

#include <gst/base/base.h>
#include <gst/pbutils/pbutils.h>
#include <string.h>

GST_DEBUG_CATEGORY_EXTERN (gst_niquadrah264enc_debug);
#define GST_CAT_DEFAULT gst_niquadrah264enc_debug

#define DOCUMENTATION_SINK_CAPS_COMM \
    "format = (string) { NV12, I420, I420_10LE, P010_10LE }, " \
    "width = (int) [ 0, 8192 ], " \
    "height = (int) [ 0, 8192 ], " \
    "framerate = " GST_VIDEO_FPS_RANGE ", " \
    "interlace-mode = (string) { progressive } "

#define DOCUMENTATION_SINK_CAPS \
    "video/x-raw, " DOCUMENTATION_SINK_CAPS_COMM

#define gst_niquadrah264enc_parent_class parent_class
G_DEFINE_TYPE (GstNiquadraH264Enc, gst_niquadrah264enc, GST_TYPE_NIQUADRAENC);

static gboolean
gst_niquadrah264enc_configure (GstNiquadraEnc * encoder)
{
  encoder->codec_format = NI_CODEC_FORMAT_H264;

  return TRUE;
}

static void
gst_niquadrah264enc_dispose (GObject * object)
{
  G_OBJECT_CLASS (parent_class)->dispose (object);
}

static void
gst_niquadrah264enc_finalize (GObject * object)
{
  G_OBJECT_CLASS (parent_class)->finalize (object);
}

static void
gst_niquadrah264enc_set_property (GObject * object, guint prop_id,
    const GValue * value, GParamSpec * pspec)
{
  GstNiquadraH264Enc *thiz = GST_NIQUADRAH264ENC (object);

  if (gst_niquadraenc_set_common_property (object, prop_id, value, pspec))
    return;

  GST_OBJECT_LOCK (thiz);

  switch (prop_id) {
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
      break;
  }
  GST_OBJECT_UNLOCK (thiz);
}

static void
gst_niquadrah264enc_get_property (GObject * object, guint prop_id,
    GValue * value, GParamSpec * pspec)
{
  GstNiquadraH264Enc *thiz = GST_NIQUADRAH264ENC (object);

  if (gst_niquadraenc_get_common_property (object, prop_id, value, pspec))
    return;

  GST_OBJECT_LOCK (thiz);
  switch (prop_id) {
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
      break;
  }
  GST_OBJECT_UNLOCK (thiz);
}

static void
gst_niquadrah264enc_class_init (GstNiquadraH264EncClass * klass)
{
  GObjectClass *gobject_class;
  GstElementClass *element_class;
  GstNiquadraEncClass *encoder_class;

  gobject_class = G_OBJECT_CLASS (klass);
  element_class = GST_ELEMENT_CLASS (klass);
  encoder_class = GST_NIQUADRAENC_CLASS (klass);

  gobject_class->dispose = gst_niquadrah264enc_dispose;
  gobject_class->finalize = gst_niquadrah264enc_finalize;
  gobject_class->set_property = gst_niquadrah264enc_set_property;
  gobject_class->get_property = gst_niquadrah264enc_get_property;

  encoder_class->configure = gst_niquadrah264enc_configure;

  gst_niquadraenc_install_common_properties (encoder_class);

  gst_element_class_set_static_metadata (element_class,
      "NETINT Quadra H264 encoder", "Codec/Encoder/Video/Hardware",
      "H264 video encoder based on libxcoder SDK",
      "Simon Shi <simon.shi@netint.cn>");

  GstCaps *sinkcaps = gst_caps_from_string
      ("video/x-raw, format=(string){ I420, I420_10LE, NV12, P010_10LE, ARGB, RGBA, ABGR, BGRA, NI_QUAD_8_4L4, NI_QUAD_10_4L4 }, "
      "width = (int) [ 1, 8192 ], height = (int) [ 1, 8192 ], framerate = "
      GST_VIDEO_FPS_RANGE " , " "interlace-mode = (string) { progressive }");
  GstCaps *srccaps = gst_caps_from_string
      ("video/x-h264, chroma-format = (string) 4:2:0, alignment=(string)au");

  /* pad templates */
  GstPadTemplate *sinktempl = gst_pad_template_new ("sink", GST_PAD_SINK,
      GST_PAD_ALWAYS, sinkcaps);
  GstPadTemplate *srctempl =
      gst_pad_template_new ("src", GST_PAD_SRC, GST_PAD_ALWAYS, srccaps);

  gst_element_class_add_pad_template (element_class, srctempl);
  gst_element_class_add_pad_template (element_class, sinktempl);

  gst_caps_unref (sinkcaps);
  gst_caps_unref (srccaps);
}

static void
gst_niquadrah264enc_init (GstNiquadraH264Enc * thiz)
{

}
