/*******************************************************************************
 *
 * Copyright (C) 2023 NETINT Technologies
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 ******************************************************************************/

/*!*****************************************************************************
 *  \file   gstniquadrahwframe.h *
 *  \brief  Header of NetInt Quadra hardware frame.
 ******************************************************************************/

#ifndef _GST_NIQUADRA_HW_FRAME_H
#define _GST_NIQUADRA_HW_FRAME_H

#include <gst/gst.h>

#include "ni_device_api.h"

G_BEGIN_DECLS
#define GST_TYPE_NI_HW_FRAME_CONTEXT            \
  (gst_ni_hw_frame_context_get_type ())
#define GST_NI_HW_FRAME_CONTEXT_CAST(obj)            \
  ((GstNiFrameContext *)(obj))
#define GST_NI_HW_FRAME_CONTEXT(obj)            \
  (GST_NI_HW_FRAME_CONTEXT_CAST(obj))
#define GST_IS_NI_HW_FRAME_CONTEXT(obj)            \
  (GST_IS_MINI_OBJECT_TYPE(obj, GST_TYPE_NI_HW_FRAME_CONTEXT))
typedef struct _GstNIFrameContext GstNiFrameContext;
typedef struct _GstNiHWFrameMeta GstNiHWFrameMeta;

struct _GstNiHWFrameMeta
{
  GstMeta meta;

  GstNiFrameContext *p_frame_ctx;
};

struct _GstNIFrameContext
{
  GstMiniObject parent;

  ni_session_context_t *p_session;
  niFrameSurface1_t *ni_surface;
  gint dev_idx;
  gint id;
};

static inline GstNiFrameContext *
gst_ni_hw_frame_context_ref (GstNiFrameContext *ctx)
{
  return (GstNiFrameContext *) gst_mini_object_ref(GST_MINI_OBJECT_CAST (ctx));
}

static inline void
gst_ni_hw_frame_context_unref (GstNiFrameContext *ctx)
{
  gst_mini_object_unref(GST_MINI_OBJECT_CAST (ctx));
}

GstNiFrameContext *gst_ni_hw_frame_context_new (ni_session_context_t *p_session,
                                                niFrameSurface1_t *ni_surface,
                                                gint dev_idx);

/*
 * When there is more than one metadata of type GST_NI_HWFRAME_META_INFO
 * in a GstBuffer, this API can be used to set the metadata ID.
 * It is not allowed to call this API after calling gst_buffer_add_ni_hwframe_meta.
 */
void gst_ni_hw_frame_context_set_id (GstNiFrameContext *ctx, gint id);

void gst_buffer_add_ni_hwframe_meta (GstBuffer *buffer, GstNiFrameContext *frame);

GType gst_ni_hw_frame_context_get_type (void);

#define GST_NI_HWFRAME_META_API_TYPE (gst_ni_hwframe_meta_api_get_type())
#define GST_NI_HWFRAME_META_INFO (gst_ni_hwframe_meta_get_info())

GType gst_ni_hwframe_meta_api_get_type (void);
const GstMetaInfo *gst_ni_hwframe_meta_get_info (void);

G_END_DECLS
#endif //_GST_NIQUADRA_HW_FRAME_H
