#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "nierrno.h"
#include "defog_network.h"
#include "ni_log.h"

static int create_dehaze_model(DehazeModelCtx *ctx, ni_network_data_t *network_data)
{
    ni_network_layer_params_t *param = &network_data->linfo.in_param[0];

    ctx->r0 = param->sizes[1];
    ctx->r1 = param->sizes[2];

    param = &network_data->linfo.out_param[0];
    ctx->dehaze_bytes = param->sizes[1] * param->sizes[2] * sizeof(float);

    pr_log("dehaze input 0 dim: %dx%d\n", ctx->r0, ctx->r1);

    ctx->dehaze = malloc(ctx->dehaze_bytes);
    if (ctx->dehaze == NULL) {
        pr_err("failed to allocate dehaze buffer\n");
        return NIERROR(ENOMEM);
    }

    return 0;
}

static void destroy_dehaze_model(DehazeModelCtx *ctx)
{
    if (ctx->dehaze != NULL) {
        free(ctx->dehaze);
        ctx->dehaze = NULL;
    }
}

static int create_dark_chnl_model(DarkChnlModelCtx *ctx, ni_network_data_t *network_data)
{
    int ret = 0;
    ni_network_layer_params_t *param = &network_data->linfo.out_param[0];
    ctx->r0 = param->sizes[1];
    ctx->r1 = param->sizes[2];

    ctx->ds_dark_bytes = ctx->r0 * ctx->r1 * sizeof(float);

    pr_log("dark chnl output 0 dim: %dx%d\n", ctx->r0, ctx->r1);

    ctx->ds_dark = malloc(ctx->ds_dark_bytes);
    if (ctx->ds_dark == NULL) {
        pr_err("failed to allocate ds_dark\n");
        return NIERROR(ENOMEM);
    }

    ctx->histo_size = 2001;
    ctx->histo = malloc(ctx->histo_size * sizeof(int));
    if (ctx->histo == NULL) {
        pr_err("failed to allocate histo\n");
        ret = NIERROR(ENOMEM);
        goto no_mem;
    }

    return 0;
no_mem:
    free(ctx->ds_dark);
    ctx->ds_dark = NULL;
    return ret;
}

static void destroy_dark_chnl_model(DarkChnlModelCtx *ctx)
{
    if (ctx->ds_dark != NULL) {
        free(ctx->ds_dark);
        ctx->ds_dark = NULL;
    }
    if (ctx->histo != NULL) {
        free(ctx->histo);
        ctx->histo = NULL;
    }
}

DehazeModel dehaze_model = {
    .create_model = create_dehaze_model,
    .destroy_model = destroy_dehaze_model,
};

DarkChnlModel dark_chnl_model = {
    .create_model = create_dark_chnl_model,
    .destroy_model = destroy_dark_chnl_model,
};
