#ifndef _DEFOG_NETWORK_H
#define _DEFOG_NETWORK_H

#include <stdint.h>
#include "netint_network.h"

typedef struct _dark_chnl_model_ctx {
    float *ds_dark;
    long ds_dark_bytes;
    int *histo;
    long histo_size;
    int r0;
    int r1;
} DarkChnlModelCtx;

typedef struct _dehaze_model_ctx {
    float *dehaze;
    long dehaze_bytes;
    int r0;
    int r1;
} DehazeModelCtx;

typedef struct dark_chnl_model {
    int (*create_model)(DarkChnlModelCtx *ctx, ni_network_data_t *network_data);
    void (*destroy_model)(DarkChnlModelCtx *ctx);
} DarkChnlModel;

extern DarkChnlModel dark_chnl_model;

typedef struct dehaze_model {
    int (*create_model)(DehazeModelCtx *ctx, ni_network_data_t *network_data);
    void (*destroy_model)(DehazeModelCtx *ctx);
} DehazeModel;

extern DehazeModel dehaze_model;

#endif
