/*
 * Copyright (c) 2010 Nicolas George
 * Copyright (c) 2011 Stefano Sabatini
 * Copyright (c) 2014 Andrey Utkin
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/**
 * @added by zheng.lv@netint.ca
 */

#ifndef _NI_LIST_HEAD_H
#define _NI_LIST_HEAD_H

#define NI_LIST_HEAD_INIT(name) { &(name), &(name) }
#define NI_LIST_HEAD(name) \
    struct ni_list_head name = NI_LIST_HEAD_INIT(name)

struct ni_list_head {
    struct ni_list_head *prev;
    struct ni_list_head *next;
};

static inline void ni_init_list_head(struct ni_list_head *head)
{
    head->next = head;
    head->prev = head;
}

static inline void ni_list_add(struct ni_list_head *add, struct ni_list_head *head)
{
    add->prev = head;
    add->next = head->next;
    head->next->prev = add;
    head->next = add;
}

static inline void ni_list_add_tail(struct ni_list_head *add, struct ni_list_head *head)
{
    add->prev = head->prev;
    add->next = head;
    head->prev->next = add;
    head->prev = add;
}

static inline void ni_list_del(struct ni_list_head *entry)
{
    entry->prev->next = entry->next;
    entry->next->prev = entry->prev;
}

static inline int ni_list_empty(struct ni_list_head *head)
{
    return head->next == head;
}

static inline int ni_list_size(struct ni_list_head *head)
{
    int size = 0;
    struct ni_list_head *temp = head;
    while (temp->next != head) {
        temp = temp->next;
        size++;
    }
    return size;
}

#define ni_offset_of(type, member) ((size_t)&((type *)0)->member)

#define ni_container_of(ptr, type, member) ({ \
    const typeof(((type *)0)->member) *__mptr = (ptr); \
    (type *)((char *)__mptr - ni_offset_of(type, member));})

#define ni_list_entry(ptr, type, member) \
    ni_container_of(ptr, type, member)

#define ni_list_first_entry(ptr, type, member) \
    ni_list_entry((ptr)->next, type, member)
#endif
