/*
 * Copyright (c) 2010 Nicolas George
 * Copyright (c) 2011 Stefano Sabatini
 * Copyright (c) 2014 Andrey Utkin
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/**
 * @file
 * API for ai to create ocr model, get output from ocr model
 * @example ocr_postprocess.h
 *
 * @added by cube.sun@netint.ca
 * use network api to create ocr model, process ocr model
 */

#ifndef _OCR_POSTPROCESS_H
#define _OCR_POSTPROCESS_H

#include <stdint.h>
#include "netint_network.h"

typedef struct _ni_ocr_network_layer {
    int32_t char_num;
    int32_t char_lib;
    int32_t output_number;
    float *output;
} ni_ocr_network_layer_t;

typedef struct ocr_detection {
    char txt[140];
    float prob;
} ocr_detection;

typedef struct OCR_model_ctx {
    int input_width;
    int input_height;
    int output_number;

    ocr_detection* det_res;
    uint8_t **out_tensor;
    ni_ocr_network_layer_t *layers;
} OCRModelCtx;

typedef struct OCR_model {
  int (*create_model)(OCRModelCtx *ctx, ni_network_data_t *network_data, int model_width, int model_height, const char *character_file);
  void (*destroy_model)(OCRModelCtx *ctx);
  int (*ni_get_detections)(OCRModelCtx *ctx);
}OCRModel;

extern OCRModel ocr;

#endif
