/*
 * Copyright (c) 2010 Nicolas George
 * Copyright (c) 2011 Stefano Sabatini
 * Copyright (c) 2014 Andrey Utkin
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/**
 * @file
 * API for ai to create vqe model, get output from vqe model
 * @example vqe_postprocess.h
 *
 * @added by cube.sun@netint.ca
 * use network api to create vqe model, process vqe model
 */

#ifndef _VQE_POSTPROCESS_H
#define _VQE_POSTPROCESS_H

#include <stdint.h>
#include "netint_network.h"

typedef struct _ni_vqe_network_layer {
    int32_t classes;
    int32_t output_number;
    float *output;
} ni_vqe_network_layer_t;

typedef struct vqe_detection {
    char txt[40];
    float conf;
} vqe_detection;

typedef struct VQE_model_ctx {
    int input_width;
    int input_height;
    float alert_threshold;
    int window_size;
    int output_number;

    vqe_detection* det_res;
    uint8_t **out_tensor;
    ni_vqe_network_layer_t *layers;
} VQEModelCtx;

typedef struct VQE_model {
  int (*create_model)(VQEModelCtx *ctx, ni_network_data_t *network_data, float alert_threshold, int window_size, int model_width, int model_height);
  void (*destroy_model)(VQEModelCtx *ctx);
  int (*ni_get_detections)(VQEModelCtx *ctx);
}VQEModel;

extern VQEModel vqe;

#endif
