#ifndef _YOLO_POSTPROCESS_311_H
#define _YOLO_POSTPROCESS_311_H

#include <stdint.h>
#include "netint_network_311.h"

#define YOLOV4  4
#define YOLOV5  5

typedef struct _ni_roi_network_layer {
    int32_t width;
    int32_t height;
    int32_t channel;
    int32_t classes;
    int32_t component;
    int32_t mask[3];
    float *biases;
    int32_t output_number;
    float *output;
} ni_roi_network_layer_t;

typedef struct box {
    union {
        float x;
        float x1;
    };
    union {
        float y;
        float y1;
    };
    union {
        float w;
        float x2;
    };
    union {
        float h;
        float y2;
    };
} box;

typedef struct detection {
    box bbox;
    float objectness;
    int classes;
    int color;
    float *prob;
    int prob_class;
    float max_prob;
} detection;

typedef struct detection_cache {
    detection *dets;
    int capacity;
    int dets_num;
} detection_cache;

struct roi_box {
    int left;
    int right;
    int top;
    int bottom;
    float prob;
    float objectness;
    int class;
};

typedef struct yolo_model_ctx {
    float obj_thresh;
    float nms_thresh;
    int input_width;
    int input_height;
    int output_number;

    uint8_t **out_tensor;
    ni_roi_network_layer_t *layers;
    detection_cache det_cache;
} YoloModelCtx;

typedef struct yolo_model {
  int (*create_model)(YoloModelCtx *ctx, ni_quadra_network_data_t *network_data, float obj_thresh, float nms_thresh, int model_width, int model_height);
  void (*destroy_model)(YoloModelCtx *ctx);
  int (*ni_get_detections)(YoloModelCtx *ctx, uint32_t img_width, uint32_t img_height, struct roi_box **roi_box, int *roi_num);
}YoloModel;

extern YoloModel yolov4;
extern YoloModel yolov5;

#endif
