@echo OFF
setlocal enabledelayedexpansion

REM Defined cript variables
set YASMDL=http://yasm.tortall.net/
set YASMVERSION=1.3.0

REM Store current directory and ensure working directory is the location of current .bat
set CALLDIR=%CD%
set SCRIPTDIR=%~dp0
set VSPATH=C

REM Initialise error check value
SET ERROR=0

REM Check what architecture we are installing on
if "%PROCESSOR_ARCHITECTURE%"=="AMD64" (
    echo Detected 64 bit system...
    set SYSARCH=64
) else if "%PROCESSOR_ARCHITECTURE%"=="x86" (
    if "%PROCESSOR_ARCHITEW6432%"=="AMD64" (
        echo Detected 64 bit system running 32 bit shell...
        set SYSARCH=64
    ) else (
        echo Detected 32 bit system...
        set SYSARCH=32
    )
) else (
    echo Error: Could not detect current platform architecture!"
    goto Terminate
)

REM Check for default install locations based on current system architecture
if "%SYSARCH%"=="32" (
    set MSVCVARSDIR=
    set WOWNODE=
) else if "%SYSARCH%"=="64" (
    set MSVCVARSDIR=\amd64
    set WOWNODE=\WOW6432Node
) else (
    goto Terminate
)

REM Check for default install locations based on current system architecture
reg.exe query "HKLM\Software%WOWNODE%\Microsoft\VisualStudio\VSPerf" /v "CollectionToolsDir2019" >nul 2>&1
if not ERRORLEVEL 1 (
    echo Visual Studio 2019 installation detected...
    call "%VSPATH%:\Program Files (x86)\Microsoft Visual Studio\2019\Community\VC\Auxiliary\Build\vcvars%SYSARCH%.bat" >nul 2>&1
    if not ERRORLEVEL 1 (
        set MSVC_VER=16
        goto MSVCVarsDone
    ) else (
        echo "Error: Could not find vcvars%SYSARCH%.bat in %VSPATH%:\Program Files (x86)\Microsoft Visual Studio\2019\Community\VC\Auxiliary\Build"
		echo Please specify the correct installation path of Visual Studio 2019...
		goto Terminate
    )
)
echo Error: Could not find Visual Studio 2019 installation!
goto Terminate

:MSVCVarsDone
REM copy the BuildCustomizations to VCTargets folder
echo Installing build customisations...
set VCTargetsPath=%VSPATH%:\Program Files (x86)\Microsoft Visual Studio\2019\Community\MSBuild\Microsoft\VC\v160\
del /F /Q "%VCTargetsPath%\BuildCustomizations\yasm.*" >nul 2>&1
copy /B /Y /V "%SCRIPTDIR%\yasm.*" "%VCTargetsPath%\BuildCustomizations\" >nul 2>&1
if %ERRORLEVEL% neq 0 (
    echo Error: Failed to copy build customisations!
    echo    Ensure that this script is run in a shell with the necessary write privileges
    goto Terminate
)

REM copy yasm executable to VC installation folder
set VCINSTALLDIR=%VSPATH%:\Program Files (x86)\Microsoft Visual Studio\2019\Community\VC
echo Installing required YASM release binary...
del /F /Q "%VCINSTALLDIR%\yasm.exe" >nul 2>&1
copy /B /Y /V "%SCRIPTDIR%\yasm-1.3.0-win%SYSARCH%\yasm.exe" "%VCINSTALLDIR%" >nul 2>&1
if %ERRORLEVEL% neq 0 (
    echo Error: Failed to install YASM binary!
    echo    Ensure that this script is run in a shell with the necessary write privileges
    goto Terminate
)
echo Finished Successfully
goto Exit

:Terminate
SET ERROR=1

:Exit
cd %CALLDIR%
exit /b %ERROR%
