#!/usr/bin/env bash

path="./";
symlink_to_file=false;
file_to_symlink=false;

# on a windows msys2 environment, detect linux symlinks for netint files and replace them with the target of symlink
# this function is primarily used for Netint internal git project where there are symlinks. Netint external releases will not have symlinks.
# this function may only be called when working_directory is top level of FFmpeg folder
# this function only scans for symlinks on this folder level and one level down
# this function only scans for symlinks that begin with '../' or '../../'
replace_symlinks_with_files_on_windows() {
    file_list=( $(find . -type f \( -iname \*ni\*.c -o -iname \*ni\*.h -o -iname \*ni\*.cpp -o -iname \*ni\*.hpp -o -iname \*.sh \)) )
    for file in ${file_list[@]}; do
        if [[ $(head -q -c 6 $file) == "../../" ]]; then
            if stat $(tail -q -c +4 $file) &> /dev/null; then
                # echo "Replaced working symlink: ${file}"
                cp $file $file.symlink
                cp $(tail -q -c +4 $file) $file
            fi
        elif [[ $(head -q -c 3 $file) == "../" ]]; then
            if stat $(cat $file) &> /dev/null; then
                # echo "Replaced working symlink: ${file}"
                cp $file $file.symlink
                cp $(cat $file) $file
            fi
        fi
    done
}

# undo the actions of replace_symlinks_with_files_on_windows() function
# removes ".symlink" suffix from files and replaces pre-existing files with them
restore_symlinks_on_windows() {
    file_list=( $(find . -type f -name \*.symlink ) )
    for file in ${file_list[@]}; do
        mv $file ${file%.*}
    done
}

while [ "$1" != "" ]; do
    case $1 in
        -h | --help)     echo "Usage: ./win_symlink_tool.sh [OPTION]";
                         echo "On windows environment, replace linux symlinks pointing outside of current "
                         echo "FFmpeg folder with the files they point to or vice-versa.";
                         echo "This script is primarily used for Netint internal git project where there "
                         echo "are symlinks. Netint external releases will not have symlinks."
                         echo "This script may only be called when working directory is FFmpeg base folder.";
                         echo "Example: ./win_symlink_tool.sh --symlink_to_file";
                         echo;
                         echo "Options:";
                         echo "-h, --help           display this help and exit";
                         echo "--symlink_to_file    back-up symlinks with '.symlink' suffix, copy in real"
                         echo "                     files pointed to by symlinks";
                         echo "--file_to_symlink    remove '.symlink' suffix from files with it";
                         exit 0
        ;;
        --symlink_to_file)    symlink_to_file=true
        ;;
        --file_to_symlink)    file_to_symlink=true
        ;;
        *)               echo "Usage: ./win_symlink_tool.sh [OPTION]...";
                         echo "Try './win_symlink_tool.sh --help' for more information";
                         exit 1
        ;;
    esac
    shift
done

if $symlink_to_file; then
    replace_symlinks_with_files_on_windows
elif $file_to_symlink; then
    restore_symlinks_on_windows
else
    echo "Must select either --symlink_to_file or --file_to_symlink"
    exit 1
fi
