@echo OFF
setlocal enabledelayedexpansion

REM Store current directory and ensure working directory is the location of current .bat
set CALLDIR=%CD%
set SCRIPTDIR=%~dp0
set APIEXAMPLEDIR=%SCRIPTDIR%..\..\..
set VSPATH=C
set VSVER=Community
set FFMPEGVER=n4.2.1

REM Check for bash env
set BASH_EXISTS=0
bash --version >nul 2>&1 && (
    set BASH_EXISTS=1
)

REM Initialise error check value
SET ERROR=0

REM Check what architecture we are installing on
if "%PROCESSOR_ARCHITECTURE%"=="AMD64" (
    set SYSARCH=64
) else if "%PROCESSOR_ARCHITECTURE%"=="x86" (
    if "%PROCESSOR_ARCHITEW6432%"=="AMD64" (
        set SYSARCH=64
    ) else (
        set SYSARCH=32
    )
) else (
    echo Error: Could not detect current platform architecture!"
    goto Terminate
)


REM Check for default install locations based on current system architecture
if "%SYSARCH%"=="32" (
    set MSVCVARSDIR=
    set WOWNODE=
) else if "%SYSARCH%"=="64" (
    set MSVCVARSDIR=\amd64
    set WOWNODE=\WOW6432Node
) else (
    goto Terminate
)

REM Check for default install locations based on current system architecture
reg.exe query "HKLM\Software%WOWNODE%\Microsoft\VisualStudio\VSPerf" /v "CollectionToolsDir2019" >nul 2>&1
if not ERRORLEVEL 1 (
    echo Visual Studio 2019 installation detected...
    call "%VSPATH%:\Program Files (x86)\Microsoft Visual Studio\2019\%VSVER%\VC\Auxiliary\Build\vcvars%SYSARCH%.bat" >nul 2>&1
    if not ERRORLEVEL 1 (
        set MSVC_VER=16
        goto APIEXAMPLE_BUILD
    ) else (
        echo "Error: Could not find vcvars%SYSARCH%.bat in %VSPATH%:\Program Files (x86)\Microsoft Visual Studio\2019\%VSVER%\VC\Auxiliary\Build"
        echo Please specify the correct installation path of Visual Studio 2019...
        goto Terminate
    )
)
echo Error: Could not find Visual Studio 2019 installation!
goto Terminate


:APIEXAMPLE_BUILD
echo %APIEXAMPLEDIR%
echo building ffmpeg xcoder api examples...
set __ni_api_example_base_dir__=%APIEXAMPLEDIR%\tools\apiexample\NI_MSVS2019_API_EXAMPLE
rd %__ni_api_example_base_dir__% /s /q
xcopy %APIEXAMPLEDIR%\tools\MSVS2019\logan\NI_MSVS2019_API_EXAMPLE\* %__ni_api_example_base_dir__%\ /e /h /d /y
xcopy %APIEXAMPLEDIR%\tools\MSVS2019\3rd_libs %__ni_api_example_base_dir__%\3rd_libs\ /e /h /d /y
set ffmpegxcoder_api_example=%__ni_api_example_base_dir__%\ffmpegxcoder_api_example.sln
set __ni_ffmpegxcoder_api_example_log_file__=%APIEXAMPLEDIR%\ffmpegxcoder_api_example_compileLog.txt
if exist %__ni_ffmpegxcoder_api_example_log_file__% del /f %__ni_ffmpegxcoder_api_example_log_file__%
md %__ni_api_example_base_dir__%\build
md %__ni_api_example_base_dir__%\build\include
md %__ni_api_example_base_dir__%\libs

if %BASH_EXISTS% equ 1 (
    if exist "%SCRIPTDIR%\install_ffmpeg_headers.sh" (
        %~d0
        cd %SCRIPTDIR%
        bash install_ffmpeg_headers.sh --ff_path ../../../FFmpeg-%FFMPEGVER% --dest_path ../../../tools/apiexample/NI_MSVS2019_API_EXAMPLE/3rd_libs/FFmpeg-%FFMPEGVER%
        cd %CALLDIR%
    )
)

xcopy %APIEXAMPLEDIR%\FFmpeg-%FFMPEGVER%\NI_MSVS2019-%FFMPEGVER%\libavutil\*.h %__ni_api_example_base_dir__%\3rd_libs\FFmpeg-%FFMPEGVER%\libavutil\ /e /h /d /y
xcopy %APIEXAMPLEDIR%\FFmpeg-%FFMPEGVER%\NI_MSVS2019-%FFMPEGVER%\x64\ReleaseDLL\*.lib %__ni_api_example_base_dir__%\libs\ /e /h /d /y
xcopy %APIEXAMPLEDIR%\FFmpeg-%FFMPEGVER%\NI_MSVS2019-%FFMPEGVER%\x64\ReleaseDLL\*.dll %__ni_api_example_base_dir__%\libs\ /e /h /d /y
xcopy %APIEXAMPLEDIR%\libxcoder_logan\NI_MSVS2019_XCODER\build\libxcoder_logan.* %__ni_api_example_base_dir__%\libs\ /e /h /d /y
xcopy %APIEXAMPLEDIR%\libxcoder_logan\NI_MSVS2019_XCODER\3rd_libs\libxcoder_logan %__ni_api_example_base_dir__%\3rd_libs\libxcoder_logan\ /e /h /d /y
xcopy %__ni_api_example_base_dir__%\libs\*.dll %__ni_api_example_base_dir__%\build\ /e /h /d /y
xcopy %__ni_api_example_base_dir__%\3rd_libs\libxcoder_logan\include\*.h %__ni_api_example_base_dir__%\build\include\ /e /h /d /y
xcopy %__ni_api_example_base_dir__%\3rd_libs\FFmpeg-%FFMPEGVER%\* %__ni_api_example_base_dir__%\build\include\ /e /h /d /y
for /f "delims=" %%b in ('where /r "C:\Program Files (x86)\Microsoft Visual Studio" devenv.exe ') do (
    echo %%b
    echo %ffmpegxcoder_api_example%
    if "%SYSARCH%"=="32" (
        %%b %ffmpegxcoder_api_example% /rebuild "Release|win32" /Out %__ni_ffmpegxcoder_api_example_log_file__%
        if errorlevel 1 (
            echo Error: Failed to build ffmpeg! rc=%errorlevel%
            goto Terminate
        )
    ) else if "%SYSARCH%"=="64" (
        %%b %ffmpegxcoder_api_example% /rebuild "Release|x64" /Out %__ni_ffmpegxcoder_api_example_log_file__%
        if errorlevel 1 (
            echo Error: Failed to build ffmpeg! rc=%errorlevel%
            goto Terminate
        )
    ) else (
        echo Error: Failed to build ffmpeg! Cannot determine SYSARCH
        goto Terminate
    )
)

if %ERRORLEVEL% neq 0 (
    echo Error: Failed to copy build customisations!
    echo Ensure that this script is run in a shell with the necessary write privileges
    goto Terminate
)
goto Exit


:Terminate
SET ERROR=1


:Exit
cd %CALLDIR%
IF "%APPVEYOR%"=="" (
    echo FINISHED
)
exit /b %ERROR%
