@echo OFF
setlocal enabledelayedexpansion

REM Store current directory and ensure working directory is the location of current .bat
set CALLDIR=%CD%
set SCRIPTDIR=%~dp0
set FFMPEGDIR=%SCRIPTDIR%..\..\..
set VSPATH=C
set VSVER=Community
set FFMPEGVER=%1
set XCODER_LATENCY=%2
set FFMPEGVER_check=0
if "%FFMPEGVER%"=="n4.2.1" set FFMPEGVER_check=1
if "%FFMPEGVER%"=="n4.3.1" set FFMPEGVER_check=1
if "%FFMPEGVER%"=="n4.4" set FFMPEGVER_check=1
if "%FFMPEGVER_check%"=="0" (
    echo Error: invalid first arg for FFmpeg version
    exit /b 1
)

REM Check for bash env
set BASH_EXISTS=0
bash --version >nul 2>&1 && (
    set BASH_EXISTS=1
)

REM Initialise error check value
SET ERROR=0

REM Check what architecture we are installing on
if "%PROCESSOR_ARCHITECTURE%"=="AMD64" (
    set SYSARCH=64
) else if "%PROCESSOR_ARCHITECTURE%"=="x86" (
    if "%PROCESSOR_ARCHITEW6432%"=="AMD64" (
        set SYSARCH=64
    ) else (
        set SYSARCH=32
    )
) else (
    echo Error: Could not detect current platform architecture!"
    goto Terminate
)


REM Check for default install locations based on current system architecture
if "%SYSARCH%"=="32" (
    set MSVCVARSDIR=
    set WOWNODE=
) else if "%SYSARCH%"=="64" (
    set MSVCVARSDIR=\amd64
    set WOWNODE=\WOW6432Node
) else (
    goto Terminate
)

REM Check for default install locations based on current system architecture
reg.exe query "HKLM\Software%WOWNODE%\Microsoft\VisualStudio\VSPerf" /v "CollectionToolsDir2019" >nul 2>&1
if not ERRORLEVEL 1 (
    echo Visual Studio 2019 installation detected...
    call "%VSPATH%:\Program Files (x86)\Microsoft Visual Studio\2019\%VSVER%\VC\Auxiliary\Build\vcvars%SYSARCH%.bat" >nul 2>&1
    if not ERRORLEVEL 1 (
        set MSVC_VER=16
        goto YASMinstall
    ) else (
        echo "Error: Could not find vcvars%SYSARCH%.bat in %VSPATH%:\Program Files (x86)\Microsoft Visual Studio\2019\%VSVER%\VC\Auxiliary\Build"
        echo Please specify the correct installation path of Visual Studio 2019...
        goto Terminate
    )
)
echo Error: Could not find Visual Studio 2019 installation!
goto Terminate


:YASMinstall
echo YASM installing...
call %FFMPEGDIR%\tools\MSVS2019\3rd_tools\YASM\install_yasm_script.bat
if %ERRORLEVEL% neq 0 (
    echo Error: Failed to copy build customisations!
    echo Ensure that this script is run in a shell with the necessary write privileges
    goto Terminate
) else (
    goto NASMinstall
)


:NASMinstall
echo NASM installing...
call %FFMPEGDIR%\tools\MSVS2019\3rd_tools\NASM\install_nasm_script.bat
if %ERRORLEVEL% neq 0 (
    echo Error: Failed to copy build customisations!
    echo Ensure that this script is run in a shell with the necessary write privileges
    goto Terminate
) else (
    goto COPYMSVS_LIBXCODER
)


:COPYMSVS_LIBXCODER
echo build libxcoder...
set __ni_xcoder_base_dir__=%FFMPEGDIR%\libxcoder\NI_MSVS2019_XCODER
set lixcoderslnpath=%__ni_xcoder_base_dir__%\libxcoder.sln
set __ni_libxcoder_log_file__=%FFMPEGDIR%\libxcoder_quadra_compileLog.txt
if exist %__ni_libxcoder_log_file__% del /f %__ni_libxcoder_log_file__%
rd %__ni_xcoder_base_dir__% /s /q
xcopy %FFMPEGDIR%\tools\MSVS2019\quadra\NI_MSVS2019_XCODER\* %__ni_xcoder_base_dir__%\ /e /h /d /y
xcopy %FFMPEGDIR%\tools\MSVS2019\3rd_libs %__ni_xcoder_base_dir__%\3rd_libs\ /e /h /d /y
md %__ni_xcoder_base_dir__%\3rd_libs\libxcoder\include
xcopy %FFMPEGDIR%\libxcoder\source\*.h %__ni_xcoder_base_dir__%\3rd_libs\libxcoder\include\ /e /h /d /y
@REM %vscodelocation% %lixcoderslnpath% /rebuild "Release|x64"
for /f "delims=" %%b in ('where /r "C:\Program Files (x86)\Microsoft Visual Studio" devenv.exe ') do (
    echo %%b
    echo %lixcoderslnpath%
    if "%SYSARCH%"=="32" (
        SET CL=
        if "%XCODER_LATENCY%"=="xcoder_latency" SET CL=%CL%" /DNI_WARN_AS_ERROR"
        SET CL=%CL%" /DNI_WARN_AS_ERROR"
        %%b %lixcoderslnpath% /rebuild "Release|win32" /Out %__ni_libxcoder_log_file__%
        if errorlevel 1 (
            echo Error: Failed to build libxcoder! rc=%errorlevel%
            goto Terminate
        )
    ) else if "%SYSARCH%"=="64" (
        SET CL=
        if "%XCODER_LATENCY%"=="xcoder_latency" SET CL=%CL%" /DNI_WARN_AS_ERROR"
        SET CL=%CL%" /DNI_WARN_AS_ERROR"
        %%b %lixcoderslnpath% /rebuild "Release|x64" /Out %__ni_libxcoder_log_file__%
        if errorlevel 1 (
            echo Error: Failed to build libxcoder! rc=%errorlevel%
            goto Terminate
        )
    ) else (
        echo Error: Failed to build libxcoder! Cannot determine SYSARCH
        goto Terminate
    )
    goto COPYMSVS_LIBXCODER_LOGAN
)
if %ERRORLEVEL% neq 0 (
    echo Error: Failed to copy build customisations!
    echo Ensure that this script is run in a shell with the necessary write privileges
    goto Terminate
)
goto Terminate


:COPYMSVS_LIBXCODER_LOGAN
echo build libxcoder_logan...
set __ni_xcoder_logan_base_dir__=%FFMPEGDIR%\libxcoder_logan\NI_MSVS2019_XCODER
set lixcoderslnpath=%__ni_xcoder_logan_base_dir__%\libxcoder_logan.sln
set __ni_libxcoder_log_file__=%FFMPEGDIR%\libxcoder_logan_compileLog.txt
if exist %__ni_libxcoder_log_file__% del /f %__ni_libxcoder_log_file__%
rd %__ni_xcoder_logan_base_dir__% /s /q
xcopy %FFMPEGDIR%\tools\MSVS2019\logan\NI_MSVS2019_XCODER\* %__ni_xcoder_logan_base_dir__%\ /e /h /d /y
xcopy %FFMPEGDIR%\tools\MSVS2019\3rd_libs %__ni_xcoder_logan_base_dir__%\3rd_libs\ /e /h /d /y
md %__ni_xcoder_logan_base_dir__%\3rd_libs\libxcoder\include
xcopy %FFMPEGDIR%\libxcoder_logan\source\*.h %__ni_xcoder_logan_base_dir__%\3rd_libs\libxcoder\include\ /e /h /d /y
@REM %vscodelocation% %lixcoderslnpath% /rebuild "Release|x64"
for /f "delims=" %%b in ('where /r "C:\Program Files (x86)\Microsoft Visual Studio" devenv.exe ') do (
    echo %%b
    echo %lixcoderslnpath%
    if "%SYSARCH%"=="32" (
        %%b %lixcoderslnpath% /rebuild "Release|win32" /Out %__ni_libxcoder_log_file__%
        if errorlevel 1 (
            echo Error: Failed to build libxcoder_logan! rc=%errorlevel%
            goto Terminate
        )
    ) else if "%SYSARCH%"=="64" (
        %%b %lixcoderslnpath% /rebuild "Release|x64" /Out %__ni_libxcoder_log_file__%
        if errorlevel 1 (
            echo Error: Failed to build libxcoder_logan! rc=%errorlevel%
            goto Terminate
        )
    ) else (
        echo Error: Failed to build libxcoder_logan! Cannot determine SYSARCH
        goto Terminate
    )
    goto COPYMSVS_FFMPEG
)
if %ERRORLEVEL% neq 0 (
    echo Error: Failed to copy build customisations!
    echo Ensure that this script is run in a shell with the necessary write privileges
    goto Terminate
)
goto Terminate


:COPYMSVS_FFMPEG
echo copying folder...
set __ni_ffmpeg_base_dir__=%FFMPEGDIR%\FFmpeg-%FFMPEGVER%\NI_MSVS2019-%FFMPEGVER%
rd %__ni_ffmpeg_base_dir__% /s /q
xcopy %FFMPEGDIR%\tools\MSVS2019\quadra+logan\NI_MSVS2019-%FFMPEGVER%\*.* %__ni_ffmpeg_base_dir__%\ /e /h /d /y
xcopy %FFMPEGDIR%\tools\MSVS2019\3rd_codecs %__ni_ffmpeg_base_dir__%\3rd_codecs\ /e /h /d /y
xcopy %FFMPEGDIR%\tools\MSVS2019\3rd_libs %__ni_ffmpeg_base_dir__%\3rd_libs\ /e /h /d /y
xcopy %FFMPEGDIR%\tools\MSVS2019\3rd_tools %__ni_ffmpeg_base_dir__%\3rd_tools\ /e /h /d /y
md %__ni_ffmpeg_base_dir__%\3rd_libs\libxcoder\include
md %__ni_ffmpeg_base_dir__%\3rd_libs\libxcoder\lib\x64\Debug
md %__ni_ffmpeg_base_dir__%\3rd_libs\libxcoder\lib\x64\Release
xcopy %__ni_xcoder_base_dir__%\..\source\*.h %__ni_ffmpeg_base_dir__%\3rd_libs\libxcoder\include\ /e /h /d /y
xcopy %__ni_xcoder_base_dir__%\build\libxcoder.* %__ni_ffmpeg_base_dir__%\3rd_libs\libxcoder\lib\x64\Release\ /e /h /d /y
xcopy %__ni_xcoder_logan_base_dir__%\..\source\*.h %__ni_ffmpeg_base_dir__%\3rd_libs\libxcoder\include\ /e /h /d /y
xcopy %__ni_xcoder_logan_base_dir__%\build\libxcoder_logan.* %__ni_ffmpeg_base_dir__%\3rd_libs\libxcoder\lib\x64\Release\ /e /h /d /y

if %BASH_EXISTS% equ 1 (
    if exist "%FFMPEGDIR%\tools\MSVS2019\quadra+logan\win_symlink_tool.sh" (
        %~d0
        cd %__ni_ffmpeg_base_dir__%/../
        bash %FFMPEGDIR%\tools\MSVS2019\quadra+logan\win_symlink_tool.sh --symlink_to_file
        cd %CALLDIR%
    )
)
if %BASH_EXISTS% equ 0 (
    ren %__ni_ffmpeg_base_dir__%\..\libavformat\ni_scte35.h ni_scte35_simlink.h
    ren %__ni_ffmpeg_base_dir__%\..\libavformat\ni_scte35.c ni_scte35_simlink.c
    xcopy /f %__ni_ffmpeg_base_dir__%\..\..\FFmpeg-n6.1\libavformat\ni_scte35.h %__ni_ffmpeg_base_dir__%\..\libavformat\ /i /y
    xcopy /f %__ni_ffmpeg_base_dir__%\..\..\FFmpeg-n6.1\libavformat\ni_scte35.c %__ni_ffmpeg_base_dir__%\..\libavformat\ /i /y
)

if not exist %__ni_ffmpeg_base_dir__%\build md %__ni_ffmpeg_base_dir__%\build
xcopy %__ni_xcoder_base_dir__%\build\*.exe %__ni_ffmpeg_base_dir__%\build\ /e /h /d /y
xcopy %__ni_xcoder_base_dir__%\build\*.lib %__ni_ffmpeg_base_dir__%\build\ /e /h /d /y
xcopy %__ni_xcoder_logan_base_dir__%\build\*.exe %__ni_ffmpeg_base_dir__%\build\ /e /h /d /y
xcopy %__ni_xcoder_logan_base_dir__%\build\*.lib %__ni_ffmpeg_base_dir__%\build\ /e /h /d /y
xcopy %FFMPEGDIR%\tools\MSVS2019\3rd_libs\SDL2-2.0.14\lib\x64\SDL2.dll %__ni_ffmpeg_base_dir__%\build\ /e /h /d /y
xcopy %FFMPEGDIR%\tools\MSVS2019\3rd_libs\zlib-1.2.11\lib\x64\zlibwapi.dll %__ni_ffmpeg_base_dir__%\build\ /e /h /d /y
if %ERRORLEVEL% neq 0 (
    echo Error: Failed to copy build customisations!
    echo Ensure that this script is run in a shell with the necessary write privileges
    goto Terminate
)
goto BUILDffmpeg


:BUILDffmpeg
echo %FFMPEGDIR%\
echo building ffmpeg...
set ffmpegpath=%__ni_ffmpeg_base_dir__%\FFmpeg-%FFMPEGVER%.sln
set __ni_ffmpeg_log_file__=%FFMPEGDIR%\ffmpeg_%FFMPEGVER%_compileLog.txt
if exist %__ni_ffmpeg_log_file__% del /f %__ni_ffmpeg_log_file__%
for /f "delims=" %%b in ('where /r "C:\Program Files (x86)\Microsoft Visual Studio" devenv.exe ') do (
    echo %%b
    echo %ffmpegpath%
    if "%SYSARCH%"=="32" (
        %%b %ffmpegpath% /build "Release|win32" /Out %__ni_ffmpeg_log_file__%
        if errorlevel 1 (
            echo Error: Failed to build ffmpeg! rc=%errorlevel%
            goto Terminate
        )
    ) else if "%SYSARCH%"=="64" (
        %%b %ffmpegpath% /build "Release|x64" /Out %__ni_ffmpeg_log_file__%
        if errorlevel 1 (
            echo Error: Failed to build ffmpeg! rc=%errorlevel%
            goto Terminate
        )
    ) else (
        echo Error: Failed to build ffmpeg! Cannot determine SYSARCH
        goto Terminate
    )
    if exist %__ni_ffmpeg_base_dir__%\setup\Release xcopy %__ni_ffmpeg_base_dir__%\setup\Release\* %__ni_ffmpeg_base_dir__%\build\ /e /h /d /y
)
if %ERRORLEVEL% neq 0 (
    echo Error: Failed to copy build customisations!
    echo Ensure that this script is run in a shell with the necessary write privileges
    goto Terminate
)
goto Exit


:Terminate
SET ERROR=1


:Exit
if %BASH_EXISTS% equ 1 (
    if exist "%FFMPEGDIR%\tools\MSVS2019\quadra+logan\win_symlink_tool.sh" (
        %~d0
        cd %__ni_ffmpeg_base_dir__%/../
        bash %FFMPEGDIR%\tools\MSVS2019\quadra+logan\win_symlink_tool.sh --file_to_symlink
        cd %CALLDIR%
    )
)
if %BASH_EXISTS% equ 0 (
    del /f %__ni_ffmpeg_base_dir__%\..\libavformat\ni_scte35.h
    del /f %__ni_ffmpeg_base_dir__%\..\libavformat\ni_scte35.c
    ren %__ni_ffmpeg_base_dir__%\..\libavformat\ni_scte35_simlink.h ni_scte35.h
    ren %__ni_ffmpeg_base_dir__%\..\libavformat\ni_scte35_simlink.c ni_scte35.c
)
cd %CALLDIR%
IF "%APPVEYOR%"=="" (
    echo FINISHED
)
exit /b %ERROR%
