@echo OFF
setlocal enabledelayedexpansion

REM Store current directory and ensure working directory is the location of current .bat
set SCRIPTDIR=%~dp0
set FFMPEGDIR=%SCRIPTDIR%..\..\..
set FFMPEGVER=%1
set FFMPEGVER_check=0
if "%FFMPEGVER%"=="n4.2.1" set FFMPEGVER_check=1
if "%FFMPEGVER%"=="n4.3.1" set FFMPEGVER_check=1
if "%FFMPEGVER%"=="n4.4" set FFMPEGVER_check=1
if "%FFMPEGVER_check%"=="0" (
    echo Error: invalid first arg for FFmpeg version. Use 'n4.2.1', 'n4.3.1' or 'n4.4'.
    exit /b 1
)

echo This script will download FFmpeg-%FFMPEGVER% to %FFMPEGDIR%\FFmpeg-%FFMPEGVER% and patch it with %FFMPEGDIR%\FFmpeg-%FFMPEGVER%_netint_*.diff
echo Requires git and gnu-patch

git clone -b %FFMPEGVER% --depth=1 https://git.ffmpeg.org/ffmpeg.git %FFMPEGDIR%\FFmpeg-%FFMPEGVER%\
if %ERRORLEVEL% neq 0 (
    echo Error: Failed to clone FFmpeg with tag %FFMPEGVER%
    exit /b 1
)

for /R %FFMPEGDIR% %%a in (FFmpeg-%FFMPEGVER%_netint_*.diff) do (
    set PATCHFILE=%%~nxa
)
if not defined PATCHFILE (
    echo Error: Cannot find Netint patch file FFmpeg-%FFMPEGVER%_netint_*.diff
    exit /b 1
)
 
echo Patching %FFMPEGDIR%\FFmpeg-%FFMPEGVER%\ with %FFMPEGDIR%\%PATCHFILE%
xcopy %FFMPEGDIR%\%PATCHFILE% %FFMPEGDIR%\FFmpeg-%FFMPEGVER%\
cd %FFMPEGDIR%\FFmpeg-%FFMPEGVER%\
patch -i .\%PATCHFILE% -p 1 -t --verbose --binary
if %ERRORLEVEL% neq 0 (
    echo Error: Failed to patch FFmpeg-%FFMPEGVER% with netint patch
    exit /b 1
)
cd %SCRIPTDIR%
