#include "ni_parse_header.h"
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define NIALIGN(x, a) (((x) + (a)-1) & ~((a)-1))
#define NIMAX(a, b) ((a) > (b) ? (a) : (b))
#define NIMIN(a, b) ((a) > (b) ? (b) : (a))
#define NI_TEST_RETCODE_FAILURE -1
#define NI_TEST_RETCODE_SUCCESS 0
#define NI_TEST_RETCODE_END_OF_STREAM 1
#define NI_TEST_RETCODE_EAGAIN 2
#define NI_TEST_RETCODE_NEXT_INPUT 3
#define NI_TEST_RETCODE_SEQ_CHANGE_DONE 4

#define FILE_NAME_LEN 256

typedef struct _device_state {
    int dec_sos_sent;
    int dec_eos_sent;
    int dec_eos_received;
    int enc_resend;
    int enc_sos_sent;
    int enc_eos_sent;
    int enc_eos_received;
} device_state_t;

typedef struct _ni_hwframe_ref_t {
    int ref_cnt;
    niFrameSurface1_t surface;
} ni_hwframe_ref_t;

char *ni_strtok(char *s, const char *delim, char **saveptr);

int get_bitdepth_factor_from_pixfmt(int pix_fmt);

int ni_to_gc620_pix_fmt(ni_pix_fmt_t pix_fmt_ni);

int gc620_to_ni_pix_fmt(int pix_fmt_gc620);

int get_pix_fmt_from_desc(const char *fmt_desc);

ni_pixel_planar_format get_pixel_planar(ni_pix_fmt_t pix_fmt);

int load_input_file(const char *filename, unsigned long *bytes_read);

int calc_swframe_size(int w, int h, ni_pix_fmt_t pix_fmt);

uint32_t read_one_swframe(int pfs, ni_file_reader_t *file_reader,
                          uint8_t *p_dst, uint32_t to_read);

void set_demo_roi_map(ni_session_context_t *p_enc_ctx);

int parse_symbolic_decoder_param(ni_xcoder_params_t *p_src);

int read_input_file(ni_file_reader_t *file_reader, int pfs);

int probe_dec_stream_info(ni_codec_format_t codec_type, void *p_stream_info,
                          ni_file_reader_t *file_reader, int *width,
                          int *height, int *bit_depth, int *fps_num,
                          int *fps_den);

int uploader_open_session(ni_session_context_t *p_upl_ctx, int width,
                          int height, ni_pix_fmt_t pix_fmt, int pool_size,
                          int devid);

int upload_send_data_get_desc(
    ni_session_context_t *p_upl_ctx,
    ni_session_data_io_t *p_swin_data, // intermediate for swf
    ni_session_data_io_t *p_in_data, int input_video_width,
    int input_video_height, void *yuv_buf);

int upload_send_data_get_desc2(
    ni_session_context_t *p_upl_ctx,
    ni_session_data_io_t *p_swin_data, // intermediate for swf
    ni_session_data_io_t *p_in_data, int input_video_width,
    int input_video_height, void *yuv_buf);

int frame_copy_props(ni_session_data_io_t *dst, const ni_session_data_io_t *src);

int frame_copy(ni_session_data_io_t *dst, const ni_session_data_io_t *src,
               bool force_copy);

void prep_reconf_demo_data(ni_session_context_t *p_enc_ctx, ni_frame_t *frame);

int prepare_enc_input_frame(ni_session_context_t *p_enc_ctx,
                            ni_session_data_io_t *p_dec_out_data,
                            ni_session_data_io_t *p_enc_in_data,
                            ni_pix_fmt_t src_fmt, int input_video_width,
                            int input_video_height);

int encoder_send_data(ni_session_context_t *p_enc_ctx,
                      ni_session_data_io_t *p_in_data, int input_video_width,
                      int input_video_height, device_state_t *p_device_state,
                      int eos);

int encoder_send_data2(ni_session_context_t *p_enc_ctx,
                       ni_session_data_io_t *p_dec_out_data,
                       ni_session_data_io_t *p_enc_in_data,
                       int input_video_width, int input_video_height,
                       device_state_t *p_device_state);

int encoder_receive_data(ni_session_context_t *p_enc_ctx,
                         ni_session_data_io_t *p_out_data, FILE *p_file,
                         volatile unsigned int *nb_pkts_received);

int decoder_send_data(ni_session_context_t *p_dec_ctx,
                      ni_session_data_io_t *p_in_data,
                      device_state_t *p_device_state,
                      ni_file_reader_t *file_reader, void *stream_info,
                      int width, int height, uint8_t *tmp_buf);

int decoder_receive_data(ni_session_context_t *p_dec_ctx,
                         ni_session_data_io_t *p_out_data,
                         device_state_t *p_device_state, int output_video_width,
                         int output_video_height, FILE *p_file);

int hwdl_frame(ni_session_context_t *p_ctx,
               ni_session_data_io_t *p_session_data, ni_frame_t *p_src_frame,
               ni_pix_fmt_t output_format);

int hwup_frame(ni_session_context_t *p_upl_ctx, ni_session_data_io_t *p_sw_data,
               ni_session_data_io_t *p_hw_data, int pfs, int frame_offset,
               ni_file_reader_t *file_reader, int *eos, void *p_yuv_buf);

int write_rawvideo_data(FILE *p_file, int width, int height,
                        ni_pix_fmt_t format, ni_frame_t *p_out_frame);

uint64_t ni_get_utime(void);

void ni_hw_frame_ref(ni_hwframe_ref_t *g_hwframe_pool,
                     const niFrameSurface1_t *p_surface);

void ni_hw_frame_unref(ni_hwframe_ref_t *g_hwframe_pool,
                       uint16_t hwframe_index);

void arg_error_exit(char *arg_name, char *param);