// Modifications Copyright (C)2022 Advanced Micro Devices, Inc. All rights reserved.
// Notified per clause 4(b) of the license

/*
 * Copyright (c) 2015-2019 The Khronos Group Inc.
 * Copyright (c) 2015-2019 Valve Corporation
 * Copyright (c) 2015-2019 LunarG, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Authors: Jeremy Hayes <jeremy@lunarg.com>
 */

#pragma once

#include <cinttypes>
#include <iostream>
#include <stdlib.h>
#include <time.h>

#include <vulkan/vulkan.hpp>

#include <app.h>

enum class EncodingMode {
    NoEncoding = 0,
    FakeGpuEncoding_RGBA = 1,
    FakeGpuEncoding_NV12 = 2,
    FakeGpuEncoding_YUV420p = 3,
    NetintEncoding_YUV420p = 4,
};

enum class VideoCodec {
    H265_Codec = 0,
    H264_Codec = 1,
    AV1_Codec = 2,
};

struct Option {
    vk::PresentModeKHR presentMode = vk::PresentModeKHR::eFifo;
    EncodingMode encodingMode = EncodingMode::NoEncoding;
    VideoCodec videoCodec = VideoCodec::H265_Codec;
    uint32_t frameCount = UINT32_MAX;
#if defined(VK_RENDER_1080P)
    int32_t width = 1920;
    int32_t height = 1080;
#else
    int32_t width = 1280;
    int32_t height = 720;
#endif
    bool use_xlib = false;
    bool use_staging_buffer = false;
    bool use_break = false;
    bool validate = false;
    bool suppress_popups = false;
    bool debug_always_cpu_wait = false;
    bool debug_fake_encoding_same_gpu = false;
    /* Autodetect suitable / best GPU by default */
    int32_t gpu_number = -1;

    /* always end with os.sep*/
    char *output_dir_path = nullptr;

    int log_level;
    char encXcoderParams[2048] = {0};
    int reconfBR_and_FKF_test = 0;

    bool need_rgb2yuv_conversion_after_rendering() const {
        return encodingMode == EncodingMode::FakeGpuEncoding_NV12 ||
               encodingMode == EncodingMode::FakeGpuEncoding_YUV420p ||
               encodingMode == EncodingMode::NetintEncoding_YUV420p;
    }

    bool color_convert_to_yuv420p() const {
        return encodingMode == EncodingMode::FakeGpuEncoding_YUV420p ||
               encodingMode == EncodingMode::NetintEncoding_YUV420p;
    }

    bool color_convert_to_nv12() const {
        return encodingMode == EncodingMode::FakeGpuEncoding_NV12;
    }
};

Option parse_arguments_to_options(int argc, char **argv);
