// Copyright (c) "2022" Advanced Micro Devices, Inc. All rights reserved.

#pragma once

#include <options.h>

class WindowSurfaceContext;
class TimestampRecord;

struct ISurfaceRenderContext {
    ISurfaceRenderContext() {}
    virtual ~ISurfaceRenderContext() {}

    ISurfaceRenderContext(const ISurfaceRenderContext &) = delete;
    ISurfaceRenderContext &operator=(const ISurfaceRenderContext &) = delete;

    virtual void init() {}

    virtual void draw(uint32_t cur_frame, TimestampRecord *p_timestamp_record) = 0;

    virtual void resize() = 0;

    virtual void cleanup() {}
};
