// Copyright (c) "2022" Advanced Micro Devices, Inc. All rights reserved.

#version 400
#extension GL_ARB_separate_shader_objects : enable
#extension GL_ARB_shading_language_420pack : enable

layout(location = 0) out vec2 fragTexCoord;

vec2 positions[6] = vec2[](vec2(-1.0, -1.0),
                           vec2(1.0, -1.0),
                           vec2(-1.0, 1.0),
                           vec2(-1.0, 1.0),
                           vec2(1.0, -1.0),
                           vec2(1.0, 1.0));
/*  (-1, -1) -- (1, -1)
       |          |
    (-1,  1) -- (1,  1)

    0 - 1
    |  /
     2
       4
     /  |
    3 - 5
 */

vec2 texcoords[6] = vec2[](
    vec2(0.0, 1.0), vec2(1.0, 1.0), vec2(0.0, 0.0), vec2(0.0, 0.0), vec2(1.0, 1.0), vec2(1.0, 0.0));

void main() {
    gl_Position = vec4(positions[gl_VertexIndex], 0.5, 1.0);
    fragTexCoord = texcoords[gl_VertexIndex];
}
