// Copyright (c) "2022" Advanced Micro Devices, Inc. All rights reserved.

#include "timestamp_record.h"

#include <fstream>
#include <iostream>

void TimestampRecord::report() {
    std::string render_report_path = "render.csv";
    std::string encoder_report_path = "encode.csv";
    if (option.output_dir_path) {
        render_report_path = std::string(option.output_dir_path) + "render.csv";
        encoder_report_path = std::string(option.output_dir_path) + "encode.csv";
    }
    std::fstream render_report(render_report_path, std::fstream::out);
    std::fstream encode_report(encoder_report_path, std::fstream::out);

    for (uint32_t i = 0; i < option.frameCount; ++i) {
        if (render_end[i] < render_start[i] || encode_end[i] < render_end[i]) {
            std::cerr << "Invalid latency date measured, skip reporting latency!\n";
            return;
        }
    }
    render_report << "frame,start_time,latency(ms)\n";
    encode_report << "frame,start_time,latency(ms)\n";
    for (uint32_t i = 0; i < option.frameCount; ++i) {
        using namespace std::chrono;
        render_report << i << ','
                      << duration_cast<microseconds>(render_start[i].time_since_epoch()).count()
                      << ','
                      << duration_cast<microseconds>(render_end[i] - render_start[i]).count() /
                             1000.0
                      << '\n';
        encode_report << i << ','
                      << duration_cast<microseconds>(render_end[i].time_since_epoch()).count()
                      << ','
                      << duration_cast<microseconds>(encode_end[i] - render_end[i]).count() / 1000.0
                      << '\n';
    }
}
