#include <stdio.h>

#include "p2p_gl_xcoder.h"

//the functions is mainly copied from ni_p2p_test.c

int uploader_open_session_gl_test(ni_session_context_t *p_upl_ctx, int *iXcoderGUID,
                            int width, int height, ni_pix_fmt_t format, int pool_size)
{
    int ret = 0;
    ni_pix_fmt_t frame_format;

    p_upl_ctx->session_id = NI_INVALID_SESSION_ID;

    // Assign the card GUID in the encoder context
    p_upl_ctx->device_handle = NI_INVALID_DEVICE_HANDLE;
    p_upl_ctx->blk_io_handle = NI_INVALID_DEVICE_HANDLE;

    // Assign the card id to specify the specific Quadra device
    p_upl_ctx->hw_id = *iXcoderGUID;

    // Assign the pixel format we want to use
    frame_format = format;

    // Set the input frame format of the upload session
    ni_uploader_set_frame_format(p_upl_ctx, width, height, frame_format,
                                    1);

    ret = ni_device_session_open(p_upl_ctx, NI_DEVICE_TYPE_UPLOAD);
    if (ret != NI_RETCODE_SUCCESS)
    {
        fprintf(stderr, "Error: uploader_open_session failure!\n");
        return ret;
    }
    else
    {
        printf("Uploader device %d session opened successfully\n",
                *iXcoderGUID);
        *iXcoderGUID = p_upl_ctx->hw_id;
    }

    // Create a P2P frame pool for the uploader sesson of pool size 2
    ret = ni_device_session_init_framepool(p_upl_ctx, pool_size, 1);
    if (ret < 0)
    {
        fprintf(stderr, "Error: Can't create frame pool\n");
        ni_device_session_close(p_upl_ctx, 1, NI_DEVICE_TYPE_UPLOAD);
    }
    else
    {
        printf("Uploader device %d configured successfully\n", *iXcoderGUID);
    }

    return ret;
}


int p2p_prepare_frames_gl_test(ni_session_context_t *p_upl_ctx, int input_video_width,
                       int input_video_height, ni_frame_t p2p_frame[], int pool_size)
{
    int i;
    int ret = 0;
    ni_frame_t *p_in_frame;

    // Allocate memory for hardware frames
    for (i = 0; i < pool_size; i++)
    {
        p_in_frame = &p2p_frame[i];

        p_in_frame->start_of_stream = 0;
        p_in_frame->end_of_stream = 0;
        p_in_frame->force_key_frame = 0;
        p_in_frame->extra_data_len = 0;

        // Allocate a hardware ni_frame structure for the encoder
        if (ni_frame_buffer_alloc_hwenc(
                p_in_frame, input_video_width, input_video_height,
                (int)p_in_frame->extra_data_len) != NI_RETCODE_SUCCESS)
        {
            fprintf(stderr, "Error: could not allocate hw frame buffer!");
            ret = -1;
            goto fail_out;
        }

#ifndef _WIN32
        // Acquire a hw frame from the upload session. This obtains a handle
        // to Quadra memory from the previously created frame pool.
        if (ni_device_session_acquire(p_upl_ctx, p_in_frame))
        {
            fprintf(stderr, "Error: failed ni_device_session_acquire()\n");
            ret = -1;
            goto fail_out;
        }
#endif
    }

    return ret;

fail_out:
    for (i = 0; i < pool_size; i++)
    {
        ni_frame_buffer_free(&(p2p_frame[i]));
    }

    return ret;
}

int encoder_open_session_gl_test(ni_session_context_t *p_enc_ctx, ni_pix_fmt_t pixel_format,
                                 int dst_codec_format,
                                 int iXcoderGUID, ni_xcoder_params_t *p_enc_params,
                                 int width, int height, ni_frame_t *p_frame)
{
    int ret = 0;

    // Enable hardware frame encoding
    p_enc_ctx->hw_action = NI_CODEC_HW_ENABLE;
    p_enc_params->hwframes = 1;

    // Provide the first frame to the Quadra encoder
    p_enc_params->p_first_frame = p_frame;

    // Specify codec, AVC vs HEVC
    p_enc_ctx->codec_format = dst_codec_format;

    p_enc_ctx->p_session_config = p_enc_params;
    p_enc_ctx->session_id = NI_INVALID_SESSION_ID;

    // Assign the card GUID in the encoder context to open a session
    // to that specific Quadra device
    p_enc_ctx->device_handle = NI_INVALID_DEVICE_HANDLE;
    p_enc_ctx->blk_io_handle = NI_INVALID_DEVICE_HANDLE;
    p_enc_ctx->hw_id = iXcoderGUID;

    p_enc_ctx->pixel_format = pixel_format;

    ni_encoder_set_input_frame_format(p_enc_ctx, p_enc_params, width, height, 8,
                                      NI_FRAME_LITTLE_ENDIAN, 1);

    // Encoder will operate in P2P mode
    ret = ni_device_session_open(p_enc_ctx, NI_DEVICE_TYPE_ENCODER);
    if (ret != NI_RETCODE_SUCCESS)
    {
        fprintf(stderr, "Error: encoder open session failure\n");
    } else
    {
        printf("Encoder device %d session open successful\n", iXcoderGUID);
    }

    return ret;
}


int recycle_frames_gl_test(ni_frame_t p2p_frame[], const int pool_size)
{
    int i;
    int cnt = 0;
    ni_retcode_t rc;

    for (i = 0; i < pool_size; i++)
    {
        rc = ni_hwframe_p2p_buffer_recycle(&p2p_frame[i]);

        if (rc != NI_RETCODE_SUCCESS)
        {
            fprintf(stderr, "Recycle failed\n");
        }

        cnt += (rc == NI_RETCODE_SUCCESS) ? 1 : 0;
    }

    return cnt;
}


int encoder_encode_frame_gl_test(ni_session_context_t *p_enc_ctx,
                         ni_frame_t *p_in_frame, int input_exhausted,
                         int &need_to_resend, int &eos_sent)
{
    static int started = 0;
    int oneSent;
    ni_session_data_io_t in_data;

    if (eos_sent == 1)
    {
        return 0;
    }

    if (need_to_resend)
    {
        goto send_frame;
    }

    p_in_frame->start_of_stream = 0;

    // If this is the first frame, mark the frame as start-of-stream
    if (!started)
    {
        started = 1;
        p_in_frame->start_of_stream = 1;
    }

    // If this is the last frame, mark the frame as end-of-stream
    p_in_frame->end_of_stream = input_exhausted ? 1 : 0;
    p_in_frame->force_key_frame = 0;

send_frame:

    in_data.data.frame = *p_in_frame;
    oneSent =
        ni_device_session_write(p_enc_ctx, &in_data, NI_DEVICE_TYPE_ENCODER);

    if (oneSent < 0)
    {
        fprintf(stderr,
                "Error: failed ni_device_session_write() for encoder\n");
        need_to_resend = 1;
        return -1;
    } else if (oneSent == 0 && !p_enc_ctx->ready_to_close)
    {
        need_to_resend = 1;
        
    } else
    {
        need_to_resend = 0;
        if (p_enc_ctx->ready_to_close)
        {
            eos_sent = 1;
        }
    }

    return 0;
}


int encoder_receive_data_gl_test(ni_session_context_t *p_enc_ctx,
                         ni_session_data_io_t *p_out_data, FILE *p_file)
{
    int packet_size = NI_MAX_TX_SZ;
    int rc = 0;
    int end_flag = 0;
    int rx_size = 0;
    int meta_size = p_enc_ctx->meta_size;
    ni_packet_t *p_out_pkt = &(p_out_data->data.packet);
    static int received_stream_header = 0;


    if (NI_INVALID_SESSION_ID == p_enc_ctx->session_id ||
        NI_INVALID_DEVICE_HANDLE == p_enc_ctx->blk_io_handle)
    {
        return 0;
    }

    if (p_file == NULL)
    {
        return -1;
    }

    rc = ni_packet_buffer_alloc(p_out_pkt, packet_size);
    if (rc != NI_RETCODE_SUCCESS)
    {
        fprintf(stderr, "Error: malloc packet failed, ret = %d!\n", rc);
        return -1;
    }

    /*
     * The first data read from the encoder session context
     * is a stream header read.
     */
    if (!received_stream_header)
    {
        /* Read the encoded stream header */
        rc = ni_encoder_session_read_stream_header(p_enc_ctx, p_out_data);

        if (rc > 0)
        {
            /* Write out the stream header */
            if (fwrite((uint8_t *)p_out_pkt->p_data + meta_size,
                       p_out_pkt->data_len - meta_size, 1, p_file) != 1)
            {
                fprintf(stderr, "Error: writing data %u bytes error!\n",
                        p_out_pkt->data_len - meta_size);
                fprintf(stderr, "Error: ferror rc = %d\n", ferror(p_file));
            }
            received_stream_header = 1;
        } else if (rc != 0)
        {
            fprintf(stderr, "Error: reading header %d\n", rc);
            return -1;
        }


        /* This shouldn't happen */
        if (p_out_pkt->end_of_stream)
        {
            return 1;
        } else if (rc == 0)
        {
            return 2;
        }
    }

receive_data:
    rc = ni_device_session_read(p_enc_ctx, p_out_data, NI_DEVICE_TYPE_ENCODER);

    end_flag = p_out_pkt->end_of_stream;
    rx_size = rc;


    if (rx_size > meta_size)
    {
        if (fwrite((uint8_t *)p_out_pkt->p_data + meta_size,
                   p_out_pkt->data_len - meta_size, 1, p_file) != 1)
        {
            fprintf(stderr, "Error: writing data %u bytes error!\n",
                    p_out_pkt->data_len - meta_size);
            fprintf(stderr, "Error: ferror rc = %d\n", ferror(p_file));
        }

    } else if (rx_size != 0)
    {
        fprintf(stderr, "Error: received %d bytes, <= metadata size %d!\n",
                rx_size, meta_size);
        return -1;
    } else if (!end_flag &&
               (((ni_xcoder_params_t *)(p_enc_ctx->p_session_config))
                   ->low_delay_mode))
    {
        goto receive_data;
    }

    if (end_flag)
    {
        printf("Encoder Receiving done\n");
        return 1;
    } else if (0 == rx_size)
    {
        return 2;
    }


    return 0;
}


int get_fd_from_ni_frame(ni_frame_t *p2p_frame, bool dup_fd)
{
    if(!p2p_frame)
    {   
        fprintf(stderr, "%s() Invaild p2p_frame\n", __func__);
        return NI_INVALID_DEVICE_HANDLE;
    }
    niFrameSurface1_t *p_surface = reinterpret_cast<niFrameSurface1_t *>(p2p_frame->p_data[3]);
    if(!p_surface)
    {
        fprintf(stderr, "%s() Invaild p_surface\n", __func__);
        return NI_INVALID_DEVICE_HANDLE;
    }
    int fd = p_surface->dma_buf_fd;
    if (dup_fd)
    {
        fd = dup(fd); // glImportMemoryFdEXT() will close the fd inside
        if (fd == -1)
        {
            fprintf(stderr, "Failed to dup fd. ERROR:%s", strerror(errno));
            fd = NI_INVALID_EVENT_HANDLE;
        }
    }
    return fd;
}