#include "ni_block_frame_set.h"

ni_block_frame_set::ni_block_frame_set() : m_frame_buffer(std::make_shared<ni_frame_set>(ni_frame_stream_compare_by_poc))
{
}

ni_block_frame_set::ni_frame_stream_t ni_block_frame_set::get_and_pop()
{
    std::unique_lock<std::mutex> lock(m_mtx);
    m_cv.wait(lock, [this]
              { return !m_frame_buffer->empty(); });

    auto itr = m_frame_buffer->begin();
    ni_frame_stream_t item = *itr;
    m_frame_buffer->erase(itr);

    return item;
}

void ni_block_frame_set::push(ni_frame_stream_t item)
{
    std::unique_lock<std::mutex> lock(m_mtx);

    push_with_no_mutex(item);

    m_cv.notify_one();
}

void ni_block_frame_set::push_with_no_mutex(ni_frame_stream_t item)
{
    m_frame_buffer->insert(item);
}

ni_block_frame_set::ni_frame_stream_t ni_block_frame_set::get_and_pop_if_begin_poc(int poc)
{
    std::unique_lock<std::mutex> lock(m_mtx);
    m_cv.wait(lock, [this, poc]
              { 
                bool this_empty = m_frame_buffer->empty();
                if(this_empty)
                {
                    return false;
                }
                auto itr = m_frame_buffer->begin();
                const auto &item = *itr;
                const int this_poc = item.poc;
                return this_poc == poc; 
              });

    auto itr = m_frame_buffer->begin();
    auto item = *itr;

    m_frame_buffer->erase(itr);

    return item;
    
}

ni_block_frame_set::~ni_block_frame_set()
{
}