#define LOG_TAG "android.hardware.nidec@1.0-impl"

#include <log/log.h>

#include "Nidec.h"

namespace android {
namespace hardware {
namespace nidec {
namespace V1_0 {
namespace implementation {

using namespace std;

// Methods from ::android::hardware::nidec::V1_0::INidec follow.
Return<void> Nidec::SetAppFlag(const hidl_string& name, const hidl_handle& fd) {
    ALOGD("setappflag: name %s, fd %d to ni_ashmem_service\n", name.c_str(), fd->data[0]);

    std::unique_lock<std::shared_mutex> wr_lock(map_rw_mutex);

    shmFd[name] = fd;
    return Void();
}

Return<void> Nidec::GetAppFlag(const hidl_string& name, GetAppFlag_cb _hidl_cb) {
    hidl_handle fd;
    int32_t ret = 0;

    ALOGD("getappflag: name %s from ni_ashmem_service\n", name.c_str());

    std::shared_lock<std::shared_mutex> rd_lock(map_rw_mutex);

    map<hidl_string, hidl_handle>::iterator iter;
    iter = shmFd.find(name.c_str());
    if (iter != shmFd.end())
    {
        fd = iter->second;
        ALOGD("getappflag: name %s, fd %d from ni_ashmem_service\n", name.c_str(), fd->data[0]);
        ret = 1;
    }

    _hidl_cb(ret, fd);
    return Void();
}

Return<void> Nidec::RemoveAppFlag(const hidl_string& name) {
    ALOGD("RemoveAppFlag: name %s to ni_ashmem_service\n", name.c_str());

    std::unique_lock<std::shared_mutex> wr_lock(map_rw_mutex);

    map<hidl_string, hidl_handle>::iterator iter;

    iter = shmFd.find(name);
    if(iter == shmFd.end())
    {
        return Void();
    }

    //~hidl_handle() will clean all resources in hidl_handle
    shmFd.erase(iter);
    
    return Void();
}

Return<void> Nidec::RemoveAllAppFlags(){
    ALOGD("RemoveAllAppFlag to ni_ashmem_service\n");

    std::unique_lock<std::shared_mutex> wr_lock(map_rw_mutex);

    for(map<hidl_string, hidl_handle>::iterator iter = shmFd.begin(); iter != shmFd.end();)
    {
        
        //~hidl_handle() will clean all resources in hidl_handle
        shmFd.erase(iter++);
    }

    return Void();

}

}  // namespace implementation
}  // namespace V1_0
}  // namespace nidec
}  // namespace hardware
}  // namespace android
