#ifndef ANDROID_HARDWARE_NIDEC_V1_0_NIDEC_H
#define ANDROID_HARDWARE_NIDEC_V1_0_NIDEC_H

#include <android/hardware/nidec/1.0/INidec.h>
#include <hidl/MQDescriptor.h>
#include <hidl/Status.h>

#include <mutex>
#include <shared_mutex>

namespace android {
namespace hardware {
namespace nidec {
namespace V1_0 {
namespace implementation {

using ::android::hardware::hidl_array;
using ::android::hardware::hidl_memory;
using ::android::hardware::hidl_string;
using ::android::hardware::hidl_vec;
using ::android::hardware::Return;
using ::android::hardware::Void;
using ::android::sp;

using namespace std;

struct Nidec : public INidec {
    // Methods from ::android::hardware::nidec::V1_0::INidec follow.
    Return<void> SetAppFlag(const hidl_string& name, const hidl_handle& fd) override;
    Return<void> GetAppFlag(const hidl_string& name, GetAppFlag_cb _hidl_cb) override;
    Return<void> RemoveAppFlag(const hidl_string &name) override;
    Return<void> RemoveAllAppFlags() override;

    // Methods from ::android::hidl::base::V1_0::IBase follow.
    map<hidl_string, hidl_handle> shmFd;
    int32_t m_fd_0;
    int32_t m_fd_1;
    hidl_handle appFd;

private:
    mutable std::shared_mutex map_rw_mutex;
};

}  // namespace implementation
}  // namespace V1_0
}  // namespace nidec
}  // namespace hardware
}  // namespace android

#endif  // ANDROID_HARDWARE_NIDEC_V1_0_NIDEC_H
