#ifndef ANDROID_HARDWARE_NIDEC_V1_0_NIDEC_H
#define ANDROID_HARDWARE_NIDEC_V1_0_NIDEC_H

#include <android/hardware/nidec/1.0/INidec.h>
#include <hidl/MQDescriptor.h>
#include <hidl/Status.h>

#include <stdexcept>
#include <string>
#include <pthread.h>

namespace android {
namespace hardware {
namespace nidec {
namespace V1_0 {
namespace implementation {

using ::android::hardware::hidl_array;
using ::android::hardware::hidl_memory;
using ::android::hardware::hidl_string;
using ::android::hardware::hidl_vec;
using ::android::hardware::Return;
using ::android::hardware::Void;
using ::android::sp;

using namespace std;

struct Nidec : public INidec {
    // Methods from ::android::hardware::nidec::V1_0::INidec follow.
    Nidec()
    {
        p_map_rwlock = &map_rwlock;
        int rwlock_init_ret = pthread_rwlock_init(p_map_rwlock, NULL);
        if(rwlock_init_ret != 0)
        {
            printf("Could not init nidec service map_rwlock! ret=%d\n", rwlock_init_ret);
            p_map_rwlock = nullptr;
            throw std::runtime_error(to_string(rwlock_init_ret));
        }
    }
    Nidec(const Nidec&) = delete;
    Nidec& operator=(const Nidec&) = delete;

    virtual ~Nidec()
    {
        if(p_map_rwlock)
        {
            int rwlock_destory_ret = pthread_rwlock_destroy(p_map_rwlock);
            if(rwlock_destory_ret != 0)
            {
                printf("destory nidec service map_rwlock failed! ret=%d\n", rwlock_destory_ret);
            }
        }
    }
    Return<void> SetAppFlag(const hidl_string& name, const hidl_handle& fd) override;
    Return<void> GetAppFlag(const hidl_string& name, GetAppFlag_cb _hidl_cb) override;
    Return<void> RemoveAppFlag(const hidl_string &name) override;
    Return<void> RemoveAllAppFlags() override;

    // Methods from ::android::hidl::base::V1_0::IBase follow.
    map<hidl_string, hidl_handle> shmFd;
    int32_t m_fd_0;
    int32_t m_fd_1;
    hidl_handle appFd;

private:
    mutable pthread_rwlock_t map_rwlock;
    mutable pthread_rwlock_t *p_map_rwlock;
    class rwlock_lock
    {
    public:
        enum class rwlock_operation
        {
            read,
            write
        };
        rwlock_lock(pthread_rwlock_t *rwlock, rwlock_operation op):_rwlock(rwlock)//rwlock must not be a nullptr
        {
            if(op == rwlock_operation::read)
            {
                pthread_rwlock_rdlock(_rwlock);
            }
            else if(op == rwlock_operation::write)
            {
                pthread_rwlock_wrlock(_rwlock);
            }
        }
        ~rwlock_lock()
        {
            pthread_rwlock_unlock(_rwlock);
        }
    private:
        pthread_rwlock_t *_rwlock;
    };
};

}  // namespace implementation
}  // namespace V1_0
}  // namespace nidec
}  // namespace hardware
}  // namespace android

#endif  // ANDROID_HARDWARE_NIDEC_V1_0_NIDEC_H
