#define LOG_TAG "android.hardware.nidec@1.0-service"

#include <android/hardware/nidec/1.0/INidec.h>
#include <hidl/LegacySupport.h>
#include <cutils/properties.h>
#include <log/log.h>

#include "Nidec.h"

using android::hardware::nidec::V1_0::INidec;
using android::hardware::nidec::V1_0::implementation::Nidec;
using android::hardware::configureRpcThreadpool;
using android::hardware::joinRpcThreadpool;
using android::sp;
using android::status_t;

int main() {
    ALOGI("ni_ashmem_service start...\n");

    configureRpcThreadpool(10 /*threads*/, true /*willJoin*/);

    sp<INidec> nidec = new Nidec();
    const status_t status = nidec->registerAsService();
    if (status != ::android::OK) {
        ALOGE("ni_ashmem_service register fail:%d\n", status);
        return 1;
    } else {
        ALOGI("ni_ashmem_service register success\n");
    }

    auto res = property_set("ni_ashmem_service_boot_completed", "yes");
    if (res != 0) {
        ALOGE("set property:ni_ashmem_service_boot_completed error:%d", res);
    } else {
        ALOGI("set property:ni_ashmem_service_boot_completed success");
    }

    joinRpcThreadpool();
    return 1; // joinRpcThreadpool should never return
}
