/*
 * Copyright 2015 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "NiQuadraOMXH264Encoder.h"

#include <media/stagefright/MediaDefs.h>

namespace android {

#define componentName                   "video_encoder.avc"
#define codingType                      OMX_VIDEO_CodingAVC
#define CODEC_MIME_TYPE                 MEDIA_MIMETYPE_VIDEO_AVC

static const CodecProfileLevel profile_levels[] = {
  {OMX_VIDEO_AVCProfileBaseline, OMX_VIDEO_AVCLevel51},

  {OMX_VIDEO_AVCProfileMain, OMX_VIDEO_AVCLevel51},

  {OMX_VIDEO_AVCProfileHigh, OMX_VIDEO_AVCLevel51},

  {OMX_VIDEO_AVCProfileHigh10, OMX_VIDEO_AVCLevel51},
};

NiQuadraOMXH264Encoder::NiQuadraOMXH264Encoder(
      const char *name,
      const OMX_CALLBACKTYPE *callbacks,
      OMX_PTR appData,
      OMX_COMPONENTTYPE **component)
      : NiQuadraOMXEncoder(name, componentName, codingType, CODEC_MIME_TYPE,
          profile_levels, ARRAY_SIZE(profile_levels), callbacks, appData, component) {
  m_codec_type = NI_CODEC_FORMAT_H264;
}

}// namespace android

android::SoftOMXComponent *createSoftOMXComponent(
        const char *name, const OMX_CALLBACKTYPE *callbacks, OMX_PTR appData,
        OMX_COMPONENTTYPE **component) {
  android::NiQuadraOMXEncoder *encoder =
        new android::NiQuadraOMXH264Encoder(name, callbacks, appData, component);

  ALOGV("Create one NiQuadraOMXH264Encoder component instance");
  return encoder;
} 
