/*
 * Copyright 2015 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef NI_OMX_DECODER_H_
#define NI_OMX_DECODER_H_

#include <media/stagefright/omx/SoftVideoDecoderOMXComponent.h>
#include <sys/time.h>

#include "ni_device_api.h"

namespace android {

//Input buffer size
#define NI_INPUT_BUF_SIZE        (1024*1024)
#define DIMENSION_2K_VIDEO       (2560*1440)
#define ONE_SECOND_IN_NANOSECOND (1000000000)

//Used to remove warnings about unused parameters
#define UNUSED(x) ((void)(x))

typedef enum _codec_format_t
{
  CODEC_FORMAT_H264 = 0,
  CODEC_FORMAT_H265 = 1,
} codec_format_t;

typedef struct _NiOMXDecCtx{
  ni_session_context_t api_ctx;
  ni_xcoder_params_t   api_param;
  ni_session_data_io_t api_pkt;
  ni_session_data_io_t api_frame;
} NiOMXDecCtx;

struct NiQuadraOMXDecoder : public SoftVideoDecoderOMXComponent {
    NiQuadraOMXDecoder(const char *name,
        const char *componentRole,
        OMX_VIDEO_CODINGTYPE codingType,
        const char *mimeType,
        const CodecProfileLevel *profileLevels,
        size_t numProfileLevels,
        const OMX_CALLBACKTYPE *callbacks,
        OMX_PTR appData,
        OMX_COMPONENTTYPE **component);

protected:
    codec_format_t m_codec_type;

    enum {
      kEnableAndroidNativeHandleExtensionIndex = kPrepareForAdaptivePlaybackIndex + 4,
      kAllocateNativeHandleExtensionIndex = kPrepareForAdaptivePlaybackIndex + 5,
      kStoreANWBufferInMetadataExtensionIndex = kPrepareForAdaptivePlaybackIndex + 6,
      kUseAndroidNativeBufferExtensionIndex = kPrepareForAdaptivePlaybackIndex + 7,
      kGetAndroidNativeBufferUsageExtensionIndex = kPrepareForAdaptivePlaybackIndex + 8,
      kStoreMetaDataInBuffersExtensionIndex = kPrepareForAdaptivePlaybackIndex + 9,
      kUseAndroidNativeBuffer2ExtensionIndex = kPrepareForAdaptivePlaybackIndex + 10,
    };

    virtual ~NiQuadraOMXDecoder();

    virtual void updatePortDefinitions(
            bool updateCrop, bool updateInputSize);

    virtual OMX_ERRORTYPE internalGetParameter(
            OMX_INDEXTYPE index, OMX_PTR param);

    virtual OMX_ERRORTYPE internalSetParameter(
   		    OMX_INDEXTYPE index, const OMX_PTR param);

    virtual OMX_ERRORTYPE getExtensionIndex(
    		const char *name, OMX_INDEXTYPE *index);

    virtual void onQueueFilled(OMX_U32 portIndex);

    virtual void onPortFlushCompleted(OMX_U32 portIndex);

    virtual void onReset();

    virtual int getColorAspectPreference();

public:
    static bool check_ni_decoder_is_available();

private:
    //Number of input and output buffers
    enum {
        kNumBuffers = 8
    };

    nsecs_t mTimeStart;
    nsecs_t mTimeCur;
    nsecs_t mTimeLast;
    uint64_t m_total_frame_decoded;
    uint64_t m_frame_decoded_one_second;

    bool m_signalled_error;

    bool m_android_native_buffers;   ///< android native buffers enabled?
    bool m_store_meta_in_buffers;
    bool m_allocate_native_handle;

    bool m_port_reset;
    bool m_need_to_flush;
 
    uint32_t m_width;
    uint32_t m_height;
    uint32_t m_output_width;
    uint32_t m_output_height;

    uint8_t m_color_primaries;
    uint8_t m_color_trc;
    uint8_t m_color_space;
    int m_full_range;

    unsigned long long m_offset;

    bool m_sos_send;            // input SOS is sent to vpu
    bool m_received_eos;        // EOS is receieved on input port
    bool m_in_flush;            // codec is flush mode, it means all inputs have been sent to vpu.
    bool m_eos_send;            // input EOS is sent to vpu
    bool m_eos;                 // output EOS is got from vpu, it means all outputs have been got from vpu

    bool m_is_closed;
    NiOMXDecCtx *m_ctx;

    int xcoder_decoder_init();

    int xcoder_decoder_close();

    int xcoder_decoder_reset();

    int xcoder_decoder_flush();

    int xcoder_decoder_send(OMX_BUFFERHEADERTYPE *inHeader, bool *send_frame);

    int retrieve_frame(OMX_BUFFERHEADERTYPE *outHeader);

    int xcoder_decoder_receive(OMX_BUFFERHEADERTYPE *outHeader, bool *get_frame);

    int xcoder_send_receive(OMX_BUFFERHEADERTYPE *inHeader, bool *send_frame,
        OMX_BUFFERHEADERTYPE *outHeader, bool *get_frame);

    status_t resetPlugin();

    bool get_color_aspects();

    DISALLOW_EVIL_CONSTRUCTORS (NiQuadraOMXDecoder);
};

} // namespace android

#endif  // NI_OMX_DECODER_H_
