## dma-buf README

### Requirements

* Linux kernel >= 5.10
* Linux kernel headers installed
* Not supported on Windows or MacOS

### Build
This Linux kernel driver requires linux kernel to support dma-buf.

Netint driver has release and engineering mode. Default is release mode. 
Engineering mode is for self test purpose only. This mode enables 
extra kernel threads to do YUV copy using CPUs.

```
To build with release mode, invoke:
$ make

To build with engineering mode, invoke:
$ make netint_build=eng

To build special customer A1 driver, invoke:
$ make a1_build=eng
This builds the driver with a custom function specific to A1
It will only compile on A1's modified kernel
```

### Install
```
$ sudo insmod netint.ko
$ sudo chmod 777 /dev/netint
```

### Test P2P DMA (push method)
This simulates a GPU card writing frames to a Quadra device before encoding.

```
# Use xcoderp2p demo app in Netint libxcoder project
$ cd ../libxcoder/build
$ ./xcoderp2p -c 0 -i ../test/akiyo_352x288p25.yuv -o aki-xcoder.265 -s 352x288 -m p2h
```

### Test P2P DMA (pull method)

Not supported on Windows or MacOS

This is a variation of P2P whereby Quadra reads memory from another PCIe device 
(usually a GPU card) instead of the PCIe device writing to Quadra memory.

This test program requires TWO Quadra devices. Either a single T2A card, two T1A 
cards, or two T1U cards.

This test program also requires root permissions.  
You will need to run libxcoder `init_rsrc` as root.

```
# Prepare an ABGR test file using FFmpeg
ffmpeg -c:v h264 -i ../libxcoder/test/1280x720_Basketball.264 -vf format=abgr -c:v rawvideo ../libxcoder/test/1280x720_Basketball.abgr

# Use xcoderp2p_read demo app in Netint libxcoder project
$ cd ../libxcoder/build
$ sudo ./ni_rsrc_update -D
$ sudo ./init_rsrc
$ sudo ./xcoderp2p_read -g 0 -s 1280x720 -i ../test/1280x720_Basketball.abgr -m r2a -c 1 -o bball_p2p.h264
```

The `-g 0` will make Quadra device 0 a proxy for a GPU card.  
The `-c 1` will make Quadra device 1 read video frames directly from Quadra 
device 0 before encoding to h264.
