#ifndef _SINGLE_LIST
#define _SINGLE_LIST

#ifdef __cplusplus
extern "C" {
#endif

#define link_entry(ptr, type, member) ({ \
        (type *)((char *)(ptr) - (char *) &((type *)0)->member); })

struct link_node {
    struct link_node *next;
};

struct link_head {
    struct link_node *head;
    struct link_node *tail;
};

static void init_link(struct link_head *link)
{
    link->head = link->tail = NULL;
}

static int link_empty(struct link_head *link)
{
    return (link->head == NULL) && (link->tail == NULL);
}

static void append_link(struct link_head *link, struct link_node *node)
{
    node->next = NULL;

    if (link_empty(link))
        link->head = link->tail = node;
    else {
        link->tail->next = node;
        link->tail = node;
    }
}

static struct link_node *peek_link(struct link_head *link)
{
    return link->head;
}

static struct link_node *pick_link(struct link_head *link)
{
    struct link_node *first = NULL;

    if (!link_empty(link)) {
        first = link->head;
        link->head = first->next;
        if (link->head == NULL)
            link->tail = NULL;
    }
    return first;
}

#ifdef __cplusplus
}
#endif

#endif /* _SINGLE_LIST */
