#!/usr/bin/env bash

# output variables:
# XCODER_AUTO_HEADERS_H: the auto generated header file.

XCODER_AUTO_HEADERS_H="${XCODER_OBJS}/xcoder_auto_headers.h"

# write user options to headers
echo "// auto generated by configure" > $XCODER_AUTO_HEADERS_H
echo "#ifndef XCODER_AUTO_HEADER_HPP" >> $XCODER_AUTO_HEADERS_H
echo "#define XCODER_AUTO_HEADER_HPP" >> $XCODER_AUTO_HEADERS_H
echo "" >> $XCODER_AUTO_HEADERS_H
echo "" >> $XCODER_AUTO_HEADERS_H

echo "#define XCODER_AUTO_BUILD_TS \"`date +%s`\"" >> $XCODER_AUTO_HEADERS_H
echo "#define XCODER_AUTO_BUILD_DATE \"`date \"+%Y-%m-%d %H:%M:%S\"`\"" >> $XCODER_AUTO_HEADERS_H
echo "#define XCODER_AUTO_UNAME \"`uname -a`\"" >> $XCODER_AUTO_HEADERS_H
echo "#define XCODER_AUTO_USER_CONFIGURE \"${XCODER_AUTO_USER_CONFIGURE}\"" >> $XCODER_AUTO_HEADERS_H
echo "#define XCODER_AUTO_CONFIGURE \"${XCODER_AUTO_CONFIGURE}\"" >> $XCODER_AUTO_HEADERS_H

echo "" >> $XCODER_AUTO_HEADERS_H
echo "" >> $XCODER_AUTO_HEADERS_H


#####################################################################################
# generate auto headers file, depends on the finished of options.sh
#####################################################################################
# write to source file

if [ $XCODER_DUMP_DATA = YES ]; then
    echo "#define XCODER_DUMP_DATA" >> $XCODER_AUTO_HEADERS_H
else
    echo "#undef XCODER_DUMP_DATA" >> $XCODER_AUTO_HEADERS_H
fi

if [ $XCODER_TRACELOG_TIMESTAMPS = YES ]; then
    echo "#define NI_LOG_TRACE_TIMESTAMPS" >> $XCODER_AUTO_HEADERS_H
else
    echo "#undef NI_LOG_TRACE_TIMESTAMPS" >> $XCODER_AUTO_HEADERS_H
fi

if [ $XCODER_SSIM_INFO_LEVEL_LOGGING = YES ]; then
    echo "#define NI_LOG_SSIM_AT_INFO" >> $XCODER_AUTO_HEADERS_H
else
    echo "#undef NI_LOG_SSIM_AT_INFO" >> $XCODER_AUTO_HEADERS_H
fi

if [ $XCODER_SELF_KILL_ERR = YES ]; then
    echo "#define XCODER_SELF_KILL_ERR" >> $XCODER_AUTO_HEADERS_H
else
    echo "#undef XCODER_SELF_KILL_ERR" >> $XCODER_AUTO_HEADERS_H
fi

if [ $XCODER_LATENCY_DISPLAY = YES ]; then
    echo "#define MEASURE_LATENCY" >> $XCODER_AUTO_HEADERS_H
else
    echo "#undef MEASURE_LATENCY" >> $XCODER_AUTO_HEADERS_H
fi

if [ $XCODER_LINUX_VIRT_IO_DRIVER = YES ]; then
    echo "#define XCODER_LINUX_VIRTIO_DRIVER_ENABLED" >> $XCODER_AUTO_HEADERS_H
else
    echo "#undef XCODER_LINUX_VIRTIO_DRIVER_ENABLED" >> $XCODER_AUTO_HEADERS_H
fi

if [ $XCODER_DISABLE_BACKTRACE_PRINT = YES ]; then
    echo "#define DISABLE_BACKTRACE_PRINT" >> $XCODER_AUTO_HEADERS_H
else
    echo "#undef DISABLE_BACKTRACE_PRINT" >> $XCODER_AUTO_HEADERS_H
fi

if [ $XCODER_ENABLE_CPU_AFFINITY = YES ]; then
    echo "#define XCODER_ENABLE_CPU_AFFINITY" >> $XCODER_AUTO_HEADERS_H
else
    echo "#undef XCODER_ENABLE_CPU_AFFINITY" >> $XCODER_AUTO_HEADERS_H
fi

if [ $XCODER_PRINT_FW_LOGS = YES ]; then
    echo "#define PRINT_FW_LOGS" >> $XCODER_AUTO_HEADERS_H
else
    echo "#undef PRINT_FW_LOGS" >> $XCODER_AUTO_HEADERS_H
fi

echo "" >> $XCODER_AUTO_HEADERS_H


# auto header EOF.
echo "#endif" >> $XCODER_AUTO_HEADERS_H
echo "" >> $XCODER_AUTO_HEADERS_H

