#ifndef _LPR_NETWORK_H
#define _LPR_NETWORK_H

#include <stdint.h>
#include <wchar.h>

#include <libavformat/avformat.h>
#include <libswscale/swscale.h>

#include "netint_network.h"

#include "yolo_postprocess.h"

struct plate_box {
    struct roi_box roi_box;
    double landmark[4][2];
};

typedef struct _lic_det_model_ctx {
    YoloModelCtx yolo_model_ctx;
    struct SwsContext *scale_ctx; //1080p yuv420p -> gbrp
} LicDetModelCtx;

typedef struct _lic_rec_model_ctx {
    int input_width;
    int input_height;

    int chars_num;
    int max_chars;
    int *characters;
    float *out_tensor[1];

    //[0]: top left;
    //[1]: top right;
    //[2]: bot left;
    //[3]: bot right;
    double landmark[4][2];

    struct SwsContext *rgb_sws_ctx; //yuv420p -> gbrp

    AVFrame persp_frame;
    AVFrame rgb_frame;

    float *rgb_planar_data;

    wchar_t *plate_result;
    char *plate_string;
    int plate_str_len;
} LicRecModelCtx;

int get_licence_plate_boxes(LicDetModelCtx *ctx, uint32_t img_width,
        uint32_t img_height, struct plate_box **plate_box, int *roi_num);
void destroy_lic_detect_model(LicDetModelCtx *ctx);
int create_lic_detect_model(LicDetModelCtx *ctx, ni_network_data_t *network_data,
        int pic_width, int pic_height, float obj_thresh, float nms_thresh);
void destroy_lic_rec_model(LicRecModelCtx *ctx);
int create_lic_rec_model(LicRecModelCtx *ctx, ni_network_data_t *network_data);
int get_plate(LicRecModelCtx *ctx, wchar_t *plate_result);
#endif
