#!/usr/bin/env python3


import cv2
import re
import numpy as np
import math
#import matplotlib.pyplot as plt
#import tensorflow.compat.v1 as tf
import os
import argparse
#tf.disable_eager_execution()




def main():
    parser = argparse.ArgumentParser()

    parser.add_argument('-i', '--input', action='store',
                        required=True,
                        help='input video or yuv')
    parser.add_argument('-f', '--ffmpeg', action='store',
                        default="ffmpeg",
                        help='ffmpeg path')

    args = parser.parse_args()

    #ffmpeg = os.path.realpath(args.ffmpeg)
    ffmpeg = 'ffmpeg'
    sequence_name = os.path.realpath(args.input)
    clean_name = sequence_name.split("/")[-1].split(".")[0]
    ext = sequence_name.split("/")[-1].split(".")[-1]
    num = re.compile(r'\d+').findall(clean_name)
    if '420' in num:
        pivot = num.index('420')
        width,height,frame_rate = num[pivot-3],num[pivot-2],int(num[pivot-1])
    else:
        print("error finding sequence information!! exiting ...")
        return

    if ext == "yuv":
        os.system("mkdir tmp_" + clean_name + "_decode_frames")
        breakframe_cmd = f"{ffmpeg} -f rawvideo -framerate {frame_rate} -s {width}x{height} -pixel_format yuv420p -i {sequence_name} -c copy -f segment -segment_time 0.01 ./tmp_{clean_name}_decode_frames/frames_%4d.yuv"
        os.system(breakframe_cmd)
    else:
        os.system("mkdir tmp_" + clean_name + "_decode_frames")
        decode_cmd = f"ffmpeg -i {sequence_name}  tmp_{clean_name}.yuv"
        os.system(decode_cmd)
        breakframe_cmd = f"{ffmpeg} -f rawvideo -framerate {frame_rate} -s {width}x{height} -pixel_format yuv420p -i tmp_{clean_name}.yuv -c copy -f segment -segment_time 0.01 ./tmp_{clean_name}_decode_frames/frames_%4d.yuv"
        os.system(breakframe_cmd)
    os.system(f"ls -R ./tmp_{clean_name}_decode_frames/* > tmp_dataset.txt")

    datafile = "tmp_dataset.txt"

    os.system("mkdir tmp_result")
    list_file = open(datafile)
    input_imgs = list_file.readlines()
    list_file.close()

    for i in range(len(input_imgs)):
        img = input_imgs[i].split('\n')[0]
        outputfilename=img.split("/")[-1]
        os.system(f"./run_dehaze.py -i {img} -o ./tmp_result/{outputfilename}")
    output_yuv = f"{clean_name}_test.yuv"
    os.system("cat tmp_result/* > " + output_yuv)
    output_video_name = output_yuv.split(".")[0] + ".mp4"
    ip = str(int(frame_rate)*2)
    to_video_cmd = f"{ffmpeg} -y -vsync 0 -s {width}x{height} -r {frame_rate} -i {output_yuv} -c:v h265_ni_quadra_enc -xcoder-params \
                    'level=0:frameRate={frame_rate}:RcEnable=0:intraPeriod={ip}:crf=12:gopPresetIdx=-1:lookaheadDepth=10:rdoLevel=3:zeroCopyMode=0:EnableRdoQuant=0' {output_video_name}"
    print(to_video_cmd)
    os.system(to_video_cmd)
    os.system("rm -rf tmp*")
#    os.system("rm -rf *yuv")


if __name__ == '__main__':
    main()
