#!/bin/bash
ARCH=$1

function error_exit() {
    echo Error
    exit 1
}

if [ $ARCH = '64' ]
then
        WORK_DIR='android_work'
        LUNCH_CMD='aosp_x86_64-eng'
else
        WORK_DIR='android_work32'
        LUNCH_CMD='aosp_x86-eng'
fi
cd ~/$WORK_DIR && echo OK || error_exit
source build/envsetup.sh &> /dev/null && echo OK || error_exit
lunch $LUNCH_CMD &> /dev/null && echo OK || error_exit
adb < /dev/null shell nohup ./vendor/bin/hw/android.hardware.nidec@1.0-service& echo OK || error_exit
adb < /dev/null  shell ni_rsrc_list -a && echo OK || error_exit
adb < /dev/null  shell ni_rsrc_mon -o json1 && echo OK || error_exit
