// Copyright (c) "2022" Advanced Micro Devices, Inc. All rights reserved.
#pragma once

#include <chrono>
#include <vector>

#include <options.h>

class TimestampRecord {
public:
    TimestampRecord(const Option &option)
        : option(option), render_start(option.frameCount), render_end(option.frameCount),
          encode_end(option.frameCount) {}

    TimestampRecord(const TimestampRecord &) = delete;
    TimestampRecord &operator=(const TimestampRecord &) = delete;

    // Note, these `mark' functions may be called from different threads,
    void mark_begin_color_conversion_and_dma(uint32_t cur_frame) {
        render_start[cur_frame] = std::chrono::steady_clock::now();
    }

    void mark_end_color_conversion_and_dma(uint32_t cur_frame) {
        render_end[cur_frame] = std::chrono::steady_clock::now();
    }

    void mark_begin_encoding(uint32_t cur_frame) {}

    void mark_end_encoding(uint32_t cur_frame) {
        encode_end[cur_frame] = std::chrono::steady_clock::now();
    }

    void report();

private:
    const Option &option;

    typedef std::chrono::steady_clock::time_point time_point;
    std::vector<time_point> render_start;
    std::vector<time_point> render_end;
    std::vector<time_point> encode_end;
};
