// Modifications Copyright (C)2022 Advanced Micro Devices, Inc. All rights reserved.
// Notified per clause 4(b) of the license

/*
 * Copyright (c) 2015-2019 The Khronos Group Inc.
 * Copyright (c) 2015-2019 Valve Corporation
 * Copyright (c) 2015-2019 LunarG, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Authors: Jeremy Hayes <jeremy@lunarg.com>
 */

#pragma once

#include <vulkan/vulkan.hpp>
#include <memory>

#ifndef NDEBUG
#define VERIFY(x) assert(x)
#else
#define VERIFY(x) ((void)(x))
#endif

#define ARRAY_SIZE(a) (sizeof(a) / sizeof(a[0]))

#ifdef _WIN32
#define ERR_EXIT(err_msg, err_class)                                                               \
    do {                                                                                           \
        if (!suppress_popups)                                                                      \
            MessageBox(nullptr, err_msg, err_class, MB_OK);                                        \
        exit(1);                                                                                   \
    } while (0)
#else
#define ERR_EXIT(err_msg, err_class)                                                               \
    do {                                                                                           \
        printf("%s\n", err_msg);                                                                   \
        fflush(stdout);                                                                            \
        exit(1);                                                                                   \
    } while (0)
#endif

vk::Bool32 check_layers(uint32_t check_count,
                        char const *const *const check_names,
                        uint32_t layer_count,
                        vk::LayerProperties *layers);

#if defined(VK_USE_PLATFORM_DISPLAY_KHR)
int find_display_gpu(int gpu_number,
                     int gpu_no_select,
                     uint32_t gpu_count,
                     std::unique_ptr<vk::PhysicalDevice[]> &physical_devices);
#endif

void init_vulkan_instance_and_phys_device(const bool in_need_validate,
                                          const bool in_need_display,
                                          const int in_force_select_gpu_number,  // -1 to ignore
                                          const int in_force_exclude_gpu_number, // -1 to ignore
                                          int *out_gpu_number,
                                          vk::Instance *out_instance,
                                          uint32_t *out_enabled_device_extension_count,
                                          const char *out_device_extension_names[],
                                          uint32_t *out_enabled_layer_count,
                                          const char *out_layer_names[],
                                          vk::PhysicalDevice *out_gpu,
                                          vk::PhysicalDeviceProperties *out_gpu_props,
                                          uint32_t *out_queue_family_count,
                                          vk::QueueFamilyProperties **out_queue_props);

bool memory_type_from_properties(const vk::PhysicalDeviceMemoryProperties &memory_properties,
                                 uint32_t typeBits,
                                 vk::MemoryPropertyFlags requirements_mask,
                                 uint32_t *typeIndex);
