// Modifications Copyright (C) 2022-2023 Advanced Micro Devices, Inc. All rights reserved.
// Notified per clause 4(b) of the license

/*
 * Copyright (c) 2015-2019 The Khronos Group Inc.
 * Copyright (c) 2015-2019 Valve Corporation
 * Copyright (c) 2015-2019 LunarG, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Authors: Jeremy Hayes <jeremy@lunarg.com>
 */

#pragma once

#include <cinttypes>
#include <iostream>

#include <vulkan/vulkan.hpp>

#include "app.h"

enum class EncodingMode {
    RGBA,
    YUV420p,
};

struct Option {
    vk::PresentModeKHR presentMode = vk::PresentModeKHR::eFifo;
    EncodingMode encodingMode = EncodingMode::RGBA;
    uint32_t frameCount = UINT32_MAX;
    int32_t width = 1280;
    int32_t height = 720;
    bool use_staging_buffer = false;
    bool validate = false;
    bool debug_always_cpu_wait = false;
    /* Autodetect suitable / best GPU by default */
    int32_t gpu_number = -1;

    /* always end with os.sep*/
    char *output_dir_path = nullptr;

    bool need_rgb2yuv_conversion_after_rendering() const {
        return encodingMode == EncodingMode::YUV420p;
    }
};

Option parse_arguments_to_options(int argc, char **argv);
