/* Modifications Copyright (C) 2022-2023 Advanced Micro Devices, Inc. All rights reserved. */

/*!****************************************************************************
 *
 * Copyright (C)  2022 NETINT Technologies.
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted.
 *
 ******************************************************************************/

#include <unistd.h>
#include <mutex>
#include <thread>

#include <ni_device_api.h>
#include <ni_util.h>

#include "encoding_device.h"
#include "options.h"

class NetintEncoding : public IEncodeDevice {
public:
    NetintEncoding(){};
    ~NetintEncoding() override{};

    NetintEncoding(const NetintEncoding &) = delete;
    NetintEncoding &operator=(const NetintEncoding &) = delete;

    void device_init(const Option &) override;
    void device_cleanup() override;

    FrameIndex get_max_number_of_inflight_commands() override {
        return kPoolSize;
    }

    ResourceIndex get_max_number_of_shared_images() override {
        return kPoolSize;
    }

    DmaBufFd allocate_shared_image_by_index(ResourceIndex index,
                                            int32_t width,
                                            int32_t height) override;

    size_t get_shared_image_size_by_index(ResourceIndex index) override;

    void import_semaphore_encoding_wait_semaphore(SyncFileFd syncFd, FrameIndex index) override {
        // netint encoding uses implicit sync.
        close(syncFd);
    }

    SyncFileFd export_semaphore_encoding_signal_semaphore(FrameIndex index) override {
        // netint encoding uses implicit sync.
        // -1 indicates an always signaled semaphore
        return SyncFileFd{-1};
    }

    void get_shared_image_plane_range_by_index(ResourceIndex index,
                                               ImagePlaneAspect image_aspect,
                                               size_t *offset,
                                               size_t *size) override;

    ResourceIndex acquire_shared_image(FrameIndex frame_index) override;

    void encoding_on_memory(uint32_t cur_frame,
                            TimestampRecord *p_timestamp_record,
                            FrameIndex frame_index,
                            ResourceIndex rsc_index) override;

    void encoding_on_dma(uint32_t cur_frame,
                            TimestampRecord *p_timestamp_record,
                            FrameIndex frame_index,
                            ResourceIndex rsc_index) override;
    int set_dma_fd_by_index(int32_t dma_buf_fd, uint32_t rsc_index) override;
    void unset_dma_fd_by_index() override;

    static constexpr uint32_t kPoolSize = 1;

private:
    Option option;

    const int fps_num = 30;
    const int fps_denomination = 1;
    const int bit_rate = 200000;
    int dst_codec_format = NI_CODEC_FORMAT_H265;

    unsigned long total_bytes_sent = 0;
    unsigned long long total_bytes_received = 0;
    int32_t input_video_width;
    int32_t input_video_height;
    int iXcoderGUID = NI_INVALID_HWID;
    int print_time;
    FILE *p_output_file = NULL;

    ni_xcoder_params_t api_param;
    ni_session_context_t enc_ctx = {0};
    ni_session_context_t upl_ctx = {0};
    ni_frame_t p2p_frame[kPoolSize] = {};
    ni_session_data_io_t out_packet = {};
    ni_p2p_sgl_t dma_addr[kPoolSize] = {};
    int32_t dma_buf_fds[kPoolSize] = {};
    int enc_eos_sent = 0;
};
