// Copyright (c) "2022" Advanced Micro Devices, Inc. All rights reserved.

#include "timestamp_record.h"

#include <fstream>
#include <iostream>

void TimestampRecord::report() {
    std::string render_report_path = "render.csv";
    std::string encoder_report_path = "encode.csv";
    std::string transfer_report_path = "transfer.csv";
    std::string receive_report_path = "receive.csv";
    std::string r_t_report_path = "r_t.csv";
    std::string total_report_path = "total.csv";

    if (option.output_dir_path) {
        render_report_path = std::string(option.output_dir_path) + "render.csv";
        encoder_report_path = std::string(option.output_dir_path) + "encode.csv";
        transfer_report_path = std::string(option.output_dir_path) + "transfer.csv";
        receive_report_path = std::string(option.output_dir_path) + "receive.csv";
        r_t_report_path = std::string(option.output_dir_path) + "r_t.csv";
        total_report_path = std::string(option.output_dir_path) + "total.csv";
    }
    std::fstream render_report(render_report_path, std::fstream::out);
    std::fstream encode_report(encoder_report_path, std::fstream::out);
    std::fstream transfer_report(transfer_report_path, std::fstream::out);
    std::fstream receive_report(receive_report_path, std::fstream::out);
    std::fstream r_t_report(r_t_report_path, std::fstream::out);
    std::fstream total_report(total_report_path, std::fstream::out);
#if 0
    for (uint32_t i = 0; i < option.frameCount; ++i) {
        if (render_end[i] < render_start[i] || transfer_end[i] < render_end[i]||encode_end[i] < transfer_end[i] || receive_end[i] < encode_end[i]) {
            std::cerr << "Invalid latency date measured, skip reporting latency!\n";
            return;
        }
    }
#endif

    render_report << "frame,start_time,latency(ms)\n";
    encode_report << "frame,start_time,latency(ms)\n";
    transfer_report << "frame,start_time,latency(ms)\n";
    receive_report << "frame,start_time,latency(ms)\n";
    r_t_report << "frame   start_time     render_latency(ms)   transfer_latency(ms)     render+trander_lat(ms)   \n";
    total_report << "frame   start_time       render(ms)   transfer(ms)    encoder(ms)   receive(ms)    total(ms)  \n";
    for (uint32_t i = 0; i < option.frameCount; ++i) {
        using namespace std::chrono;
        render_report << i << ','
                      << duration_cast<microseconds>(render_start[i].time_since_epoch()).count()
                      << ','
                      << duration_cast<microseconds>(render_end[i] - render_start[i]).count() /
                             1000.0
                      << '\n';
        transfer_report << i << ','
                      << duration_cast<microseconds>(render_end[i].time_since_epoch()).count()
                      << ','
                      << duration_cast<microseconds>(transfer_end[i] - render_end[i]).count() /
                             1000.0
                      << '\n';

        encode_report << i << ','
                      << duration_cast<microseconds>(transfer_end[i].time_since_epoch()).count()
                      << ','
                      << duration_cast<microseconds>(encode_end[i] - transfer_end[i]).count() / 1000.0
                      << '\n';
        receive_report << i << ','
                      << duration_cast<microseconds>(encode_end[i].time_since_epoch()).count()
                      << ','
                      << duration_cast<microseconds>(receive_end[i] - encode_end[i]).count() / 1000.0
                      << '\n';
        r_t_report << i << "    "
                      << duration_cast<microseconds>(render_start[i].time_since_epoch()).count()
                      << "    "
                      << duration_cast<microseconds>(render_end[i] - render_start[i]).count() / 1000.0
                      << "    "
                      << duration_cast<microseconds>(transfer_end[i] - render_end[i]).count() / 1000.0
                      << "     "
                      << duration_cast<microseconds>(transfer_end[i] - render_start[i]).count() /
                             1000.0
                      << '\n';
       total_report << i << "       "
                      << duration_cast<microseconds>(render_start[i].time_since_epoch()).count()
                      << "        "
                      << duration_cast<microseconds>(render_end[i] - render_start[i]).count() / 1000.0
                      << "        "
                      << duration_cast<microseconds>(transfer_end[i] - render_end[i]).count() / 1000.0
                      << "        "
                      << duration_cast<microseconds>(encode_end[i] - transfer_end[i]).count() / 1000.0
                      << "        "
                      << duration_cast<microseconds>(receive_end[i] - encode_end[i]).count() / 1000.0
                      << "        "
                      << duration_cast<microseconds>(receive_end[i] - render_start[i]).count() / 1000.0
		      << '\n';


    }
}
