## P2P DMA sample

### Hardware requirements

1) Nvidia GPU - list of compatible GPUs with open kernel modules support: https://github.com/NVIDIA/open-gpu-kernel-modules
2) NetInt Quadra Encoder (T1, T2)

### Dependencies

#### Operating system

    Ubuntu-24.04 LTS or above

#### Build tools


#### Nvidia driver (open kernel module) and Toolkit (CUDA >= 13)

3) install new open kernel driver
   sudo apt update
   sudo apt install nvidia-open # This will install the latest nvidia open kernel module driver (590 at the time of writing)
   sudo reboot

4) install Nvidia toolkit (for seamless dma-buf integration, CUDA 12.x+ is recommended)
   wget https://developer.download.nvidia.com/compute/cuda/repos/ubuntu2404/x86_64/cuda-keyring_1.1-1_all.deb
   sudo dpkg -i cuda-keyring_1.1-1_all.deb
   sudo apt-get update
   sudo apt-get install -y cuda-toolkit-13-0
   # Add CUDA to PATH
   echo 'export PATH=/usr/local/cuda-13.0/bin:$PATH' >> ~/.bashrc
   echo 'export LD_LIBRARY_PATH=/usr/local/cuda-13.0/lib64:$LD_LIBRARY_PATH' >> ~/.bashrc
   source ~/.bashrc

#### NetInt software stack

5) extract NetInt’s release package

6) build NetInt dma-buf kernel driver and install
``` bash
cd dma-buf
make -j
insmod netint.ko. # Need to redo it after reboot # This will create a new character device: /dev/netint
sudo chmod 777 /dev/netint #  change the permission of character device
```

7) build NetInt libxcoder
``` bash
cd libxcoder
./build.sh
# results in directory `build`
```

8) initialize NetInt encoder card resources
``` bash
./build/init_rsrc # Need to redo it after reboot
```

9) extract NetInt’s release, and install firmware
```
----------/quadra_quick_installer.sh
...
```

``` bash
./quadra_quick_installer.sh # follow the prompt to install firmware
```

### Build

1) run make and build the sample
``` bash
cd nvidia_p2p_read/
make
```

### Run

1) start p2p read from GPU and encoding in Quadra
``` bash
# Access NetInt card resources requires sudo privilleges.
./xcoderp2p_read_cuda -l trace -c 0 -g 0 -i input.rgb -s 1280x720 -m r2h -o p2p_read_output.h265 > p2p.log 2>&1
```
