## p2p opengl sample

### Hardware requirements
1) gfx9 above AMD GPU
2) NetInt Quadra Encoder (T1, T2, T4)

### Dependencies

#### Opengl driver and opengl develop packages

Using `glxinfo` to Check the information of Opengl.

If the OpenGL driver is not installed in your environment try to install it based on your GPU.

For develop packages.

On Ubuntu-22.04 install

mesa-common-dev libglu1-mesa-dev freeglut3-dev mesa-utils
libegl1-mesa-dev libglfw3-dev libsdl2-dev libglew-dev
libdrm-dev libgles2-mesa-dev libglfw3-dev

#### NetInt software stack

1）extract NetInt’s package

2） build NetInt dma-buf kernel driver and install
``` bash
cd dma-buf
make -j
insmod netint.ko. # Need to redo it after reboot
```

3）build NetInt libxcoder
``` bash
cd libxcoder
./build.sh # results in directory `build`
```

4）initialize NetInt encoder card resources
``` bash
sudo ./build/init_rsrc # Need to redo it after reboot
```

5）extract NetInt’s release, and install firmware
```
----------/quadra_quick_installer.sh
...
```

``` bash
./quadra_quick_installer.sh # follow the prompt to install firmware
```

### Build 

```bash
cd p2p_gl
make
```

### Run

**NOTE:** By default, this program requires a graphical interface to run successfully if no parameters are specified.

```bash
cd p2p_gl
sudo ./p2p_gl
```

If glfw or glew can not be initialized with `sudo` try the commands below.

```bash
sudo chmod 777 /dev/netint
sudo rm /dev/shm/NI_*
init_rsrc
./p2p_gl
```

If you don't want to use a graphical interface to run this demo you can try to use the command below.

```bash
EGL_PLATFORM=surfaceless ./p2p_gl egl
```
