#ifndef P2P_GL_TEST3_EGL
#define P2P_GL_TEST3_EGL

#include <memory>

#include <EGL/egl.h>
#include <EGL/eglext.h>

#include <GLES2/gl2.h>
#include <GLES2/gl2ext.h>

#include <GLES3/gl3.h>


#include "p2p_gl_base.h"

class GL_egl_display
{
public:

    GL_egl_display();

    bool initialized() const
    {
        return init_;
    }

    ~GL_egl_display()
    {
        if (init_)
        {
            eglMakeCurrent(eglDisplay_, EGL_NO_SURFACE, EGL_NO_SURFACE, EGL_NO_CONTEXT);
            eglDestroyContext(eglDisplay_, eglContext_);
            eglTerminate(eglDisplay_);
        }
    }

    EGLDisplay get_display() const
    {
        return eglDisplay_;
    }

    EGLContext get_context() const
    {
        return eglContext_;
    }

    bool make_current_display() const
    {
        return eglMakeCurrent(eglDisplay_, EGL_NO_SURFACE, EGL_NO_SURFACE, eglContext_) == EGL_TRUE;
    }

private:

    GL_egl_display(const GL_egl_display &) = delete;
    GL_egl_display &operator=(const GL_egl_display &) = delete;

    EGLDisplay eglDisplay_;
    EGLContext eglContext_;//eglTerminate will destory this
    bool init_;
};

class GL_rgba_egl : public GL_rgba_base
{
public:
    GL_rgba_egl(int fd, int w, int h, std::shared_ptr<GL_egl_display> display);
    GL_rgba_egl(const GL_rgba_egl &) = delete;
    GL_rgba_egl &operator=(const GL_rgba_egl &) = delete;

    GL_rgba_egl(GL_rgba_egl &&);
    GL_rgba_egl &operator=(GL_rgba_egl &&);
    ~GL_rgba_egl();

    bool initialized() const override;
    bool make_current() const override;

private:
    static PFNEGLCREATEIMAGEKHRPROC get_eglCreateImageKHR();
    static PFNEGLDESTROYIMAGEKHRPROC get_eglDestroyImageKHR();
    static PFNGLEGLIMAGETARGETTEXTURE2DOESPROC get_glEGLImageTargetTexture2DOES();

    int fd_;
    int w_;
    int h_;
    std::shared_ptr<GL_egl_display> display_;
    GLuint texture_;
    EGLImageKHR eglImage_;
    GLuint fbo_;
    bool initialized_;
};

#endif
