#ifndef P2P_GL_TEST3_GL_H
#define P2P_GL_TEST3_GL_H

#include <iostream>
#include <memory>

#include <GLFW/glfw3.h>

#include "p2p_gl_base.h"

class GLFW_GLEW_EXT_INIT
{
public:
    bool initialized() const
    {
        return init_;
    }

    ~GLFW_GLEW_EXT_INIT()
    {
        if (init_)
        {
            glfwDestroyWindow(inside_window_);
            glfwTerminate();
        }
    }

    static GLFW_GLEW_EXT_INIT &init_gwfw_glew_ext();

private:
    GLFW_GLEW_EXT_INIT();

    GLFW_GLEW_EXT_INIT(const GLFW_GLEW_EXT_INIT &) = delete;
    GLFW_GLEW_EXT_INIT &operator=(const GLFW_GLEW_EXT_INIT &) = delete;

    bool init_;
    GLFWwindow *inside_window_;
};

class GLFW_window
{
public:
    explicit GLFW_window(int width = 1920, int height = 1080);

    GLFW_window(const GLFW_window &) = delete;
    GLFW_window &operator=(const GLFW_window &) = delete;

    GLFWwindow *window() const
    {
        return window_;
    }

    bool initialized()
    {
        return window_ != nullptr;
    }

    ~GLFW_window()
    {
        glfwDestroyWindow(window_);
    }

private:
    GLFWwindow *window_;
};

class GL_rgba_glew : public GL_rgba_base
{
public:
    GL_rgba_glew(int fd, int w, int h, std::shared_ptr<GLFW_window> window);

    GL_rgba_glew(const GL_rgba_glew &) = delete;
    GL_rgba_glew &operator=(const GL_rgba_glew &) = delete;

    GL_rgba_glew(GL_rgba_glew &&);
    GL_rgba_glew &operator=(GL_rgba_glew &&);

    ~GL_rgba_glew();

    GLuint get_texture() const
    {
        return texture_;
    }

    // GLuint get_memobj()
    // {
    //     return memobj_;
    // }

    GLuint get_fbo() const
    {
        return fbo_;
    }

    bool initialized() const override
    {
        return initialized_;
    }

    bool make_current() const override;

private:
    int fd_;
    int w_;
    int h_;
    std::shared_ptr<GLFW_window> window_;
    GLuint texture_;
    GLuint memobj_;
    GLuint fbo_;
    bool initialized_;
};

#endif